/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/**************************************************************/
#include <assert.h>
#include <stdio.h>
#ifdef UNIX
#include <sys/types.h>
#include <netinet/in.h>
#endif
#include "skt.h"
/**************************************************************/

value skt_push_int(		/* ML */
        value buf_v,
	value ofs_v,
	value i_v
) {
  long ofs ;
  uint32 i ;
  uint32 *buf ;
  SKTTRACE;

  if (!Is_long(ofs_v))
    invalid_argument("push_int:non-integer arguments[0]") ;
  if (!Is_long(i_v))
    invalid_argument("push_int:non-integer arguments[1]") ;

  ofs = Long_val(ofs_v) ;

  if ((ofs % 4) != 0) 
    invalid_argument("push_int:offset is not 32bit-aligned") ;

  i = (uint32) Long_val(i_v) ;
  buf = (uint32*) String_val(buf_v) ;
  buf[ofs/4] = htonl(i) ;
  return Val_unit ;
}

/**************************************************************/

value skt_pop_int(		/* ML */
        value buf_v,
	value ofs_v
) {
  value i_v ;
  long ofs ;
  uint32 *buf ;
  uint32 i ;
  SKTTRACE;

  ofs = Long_val(ofs_v) ;

  if ((ofs % 4) != 0) 
    invalid_argument("pop_int:offset is not aligned") ;

  buf = (uint32*) String_val(buf_v) ;
  i = ntohl(buf[ofs/4]) ;

  /* This is guaranteed to be an integer value.
   */
  i_v = Val_long(i) ;
  return i_v ;
}

/**************************************************************/
