/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/**************************************************************/
/* POLL.C */
/* Author: Mark Hayden, 5/96 */
/**************************************************************/
#include "skt.h"
#include <stdio.h>
#include <assert.h>
/**************************************************************/

#if defined(HAS_SELECT) || defined(_WINSOCKAPI_)

/**************************************************************/
/* For SP2, these need to be defined here before the next
 * header files.  
 */
#ifdef SKT_PROTO
extern bzero(char *b1, int len) ;
void *memset(void *s, int c, size_t n);
#endif /* SKT_PROTO */

/**************************************************************/
#include <sys/types.h>

#ifndef _WINSOCKAPI_
#include <sys/time.h>
#endif

#ifdef HAS_SYS_SELECT
#include <sys/select.h>
#endif
/**************************************************************/

#ifdef FD_ISSET			/* from ocaml/unix/select.c */
typedef fd_set file_descr_set;
#else
typedef int file_descr_set;
#define FD_SETSIZE (sizeof(int) * 8)
#define FD_SET(fd,fds) (*(fds) |= 1 << (fd))
#define FD_CLR(fd,fds) (*(fds) &= ~(1 << (fd)))
#define FD_ISSET(fd,fds) (*(fds) & (1 << (fd)))
#define FD_ZERO(fds) (*(fds) = 0)
#endif /* FD_ISSET */

/**************************************************************/

#ifdef SKT_PROTO
extern int recv(int s, char *buf, int len, int flags) ;
extern int select(
        int width, 
	file_descr_set *readfds, 
	file_descr_set *writefds, 
	file_descr_set *exceptfds, 
	struct timeval *timeout
) ;
#endif

/**************************************************************/

value skt_poll(			/* ML */
        value man_v,
	value buf_v,
	value ofs_v
) {
  value ret_v ;
  int32 first_word ;
  value first_word_v ;
  int retcode ;
  int i, nsocks, sock ;
  value socks_v ;
  value handlers_v ;

  /* select() will always be called with a zero timeout.
   */
  static struct timeval tv = { 0, 0 };
  static struct timeval * tvp = &tv ;
  static file_descr_set read_fds ;

  /* Unpack the args.
   */
  socks_v    = Field(man_v,MAN_SOCKS) ;
  handlers_v = Field(man_v,MAN_HANDLERS) ;
  
  nsocks = Wosize_val(socks_v) ; /* from array.c */

  /* Initialize our fd set.
   */
  FD_ZERO(&read_fds) ;
  for (i=0;i<nsocks;i++) {
    sock = Int_val(Field(socks_v, i)) ;
    FD_SET(sock, &read_fds);
  }
    
  /* Do non-blocking select.
   */
  retcode = select(FD_SETSIZE, &read_fds, NULL, NULL, tvp);
  
  /* Return immediately if there was nothing, or
   * if we got a signal during the system call.
   */
  if (retcode <=  0) {
    if (retcode == 0 || (retcode == -1 && h_errno == EINTR)) {
      ret_v = Val_false ;
      goto done ;
    }
    uerror("poll:select", Nothing);
  }

  /* Look for descriptors that have data. 
   */
  for (i=0;i<nsocks;i++) {
    sock = Int_val(Field(socks_v,i)) ;

    /* If not set, check the next one.
     */
    if (!FD_ISSET(sock, &read_fds)) 
      continue ;
    
    if (Is_block(Field(handlers_v,i))) {
      /* Allocation occurs here.
       */
      callback(Field(Field(handlers_v,i),0), Val_unit) ;
      break ;
    } else {
      int ofs, max_len ;

      /* For these handlers, we manage the MBUF so that the
       * recv can be done directly.  
       */

      /* Unpack some information.
       */
      ofs     = Long_val(ofs_v) ;
      max_len = Long_val(Field(man_v, MAN_MAX_LEN)) ;

      /* Receive the data off the socket.
       */
      retcode = recv(sock, &Byte(buf_v, ofs), max_len, 0) ;
      
      /* If no data or other problems, handle them here.
       */
      if (retcode <= 0) {
	if (retcode < 0 && h_errno == EAGAIN)
	  continue ;
#ifdef ECONNREFUSED
	if (retcode < 0 && h_errno == ECONNREFUSED) /* for Linux */
	  continue ;
#endif
	uerror("poll", Nothing);
      }

      {
	int32 *buf ;
	buf = (int32*) String_val(buf_v) ;
	first_word = ntohl(buf[ofs/4]) ;
	first_word_v = Val_int(first_word) ;
      }

      /* Allocation can occur here.
       */
      callback2(Field(man_v,MAN_HANDLER),first_word_v,Val_long(retcode)) ;
      break ;
    }
  }

  /* We got data, so return true.
   */
  ret_v = Val_true ;

done:
  return ret_v ;
}

/**************************************************************/

#else 

value skt_poll() { invalid_argument("poll not implemented"); }

#endif

/**************************************************************/
