/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/**************************************************************/
/* Include these here so that the IPM_BASE
 * option will work.
 */
#ifdef UNIX
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#endif
/**************************************************************/

#include "skt.h"
#include "memory.h"

#if defined(HAS_SOCKETS) && defined(HAS_IP_MULTICAST) && defined(IN_MULTICAST)

#ifdef BIG_ENDIAN		/* for SP2 */
#undef BIG_ENDIAN
#endif

#ifdef SKT_PROTO
int setsockopt(int s, int level, int optname, const char *optval, int optlen) ;
#endif

value skt_has_ip_multicast() {	/* ML */
  return Val_true ; 
}

/**************************************************************/

/* Do whatever is appropriate to prepare multicast sockets.
 */

/* Right now: do nothing.
 */
value skt_setsock_multicast(	/* ML */
        value sock_v,
	value loopback_v
) {
/*
  int sock = Int_val(sock_v) ;
*/
  /* int ret ; */
  /* unsigned int int_value ; */

  /* Set the time-to-live value to 3:  only within site.
   */
/*
    char_value = 4 ;
    ret = setsockopt(sock,
    IPPROTO_IP, IP_MULTICAST_TTL,
    &char_value, sizeof(char_value)) ;
    if (ret < 0) 
      uerror("setsockopt(time-to-live)", Nothing) ;
*/

  /* Set whether or not this socket will have loopback.
   */
/*
  int_value = Bool_val(loopback_v) ;
  ret = setsockopt(sock, IPPROTO_IP, IP_MULTICAST_LOOP,
		   (void*) &int_value, sizeof(int_value)) ;
  if (ret < 0)
    uerror("setsockopt(loopback)", Nothing);
*/

  return Val_unit ;
}

/**************************************************************/

/* Join an IP multicast group.
 */
value skt_setsock_join(		/* ML */
        value sock_v,
	value group_v
) {
  struct ip_mreq mreq ;
  int sock = Int_val(sock_v) ;
  int ret ;
  
  if (!IN_MULTICAST(mreq.imr_multiaddr.s_addr))
    uerror("setsockopt:join:invalid multicast address", Nothing) ;
  
  mreq.imr_multiaddr.s_addr = GET_INET_ADDR(group) ;
  mreq.imr_interface.s_addr = INADDR_ANY ;
  ret = setsockopt(sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (void*)&mreq, sizeof(mreq)) ;
  if (ret < 0) uerror("setsockopt:join", Nothing) ;

  return Val_unit ;
}

/**************************************************************/

/* Leave an IP multicast group.
 */
value skt_setsock_leave(	/* ML */
	value sock_v,
	value group_v
) {
  struct ip_mreq mreq ;
  int sock = Int_val(sock_v) ;
  int ret ;
  
  if (!IN_MULTICAST(mreq.imr_multiaddr.s_addr))
    uerror("setsockopt:leave:invalid multicast address", Nothing) ;

  mreq.imr_multiaddr.s_addr = GET_INET_ADDR(group_v) ;
  mreq.imr_interface.s_addr = INADDR_ANY ;
  ret = setsockopt(sock, IPPROTO_IP, IP_DROP_MEMBERSHIP, (void*)&mreq, sizeof(mreq)) ;
  if (ret < 0) uerror("setsockopt:leave", Nothing) ;

  return Val_int(ret) ;
}

/**************************************************************/

#else /* HAS_SOCKETS */

value skt_has_ip_multicast()  { return Val_false ; }
value skt_setsock_multicast() { invalid_argument("setsock_multicast not implemented"); }
value skt_setsock_leave()     { invalid_argument("setsock_leave not implemented"); }
value skt_setsock_join()      { invalid_argument("setsock_join not implemented"); }

#endif /* HAS_SOCKETS */

/**************************************************************/
