/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/***********************************************************************/
/*                                                                     */
/*  Extracted from the Unix library and made usable for the Winsock    */
/*  library by Robbert van Renesse at Cornell University.              */
/*                                                                     */
/***********************************************************************/

#include <time.h>
#include "skt.h"

#ifdef HAS_GETTIMEOFDAY

#include <sys/types.h>
#include <sys/time.h>

value skt_gettimeofday(value a_v) {               /* ML */
  struct timeval tp ;
  double ret ;
  value ret_v ;

  Push_roots(roots,1) ;
  roots[0] = a_v ;
  SKTTRACE;
  
  if (gettimeofday(&tp, NULL) == -1) 
    uerror("gettimeofday", Nothing);
  
  ret = (double) tp.tv_sec + (double) tp.tv_usec / 1e6 ;
  ret_v = copy_double(ret) ;
  modify(&Field(roots[0],0),ret_v) ;
  Pop_roots();
  return Val_unit ;
}

value skt_gettimeofday_native(value a_v) {               /* ML */
  struct timeval tp ;
  double ret ;
  SKTTRACE;

  if (gettimeofday(&tp, NULL) == -1) 
    uerror("gettimeofday", Nothing);
  
  ret = (double) tp.tv_sec + (double) tp.tv_usec / 1e6 ;
  Store_double_field(a_v,0,ret) ;
  return Val_unit ;
}

#else

#ifdef PLARGE_INTEGER

#include <windows.h>

static double gettimeofday(void)                /* ML */
{
  double time ;
  static inited = 0 ;
  static double PerformanceCounterTicksPerSecond = 0.0 ;
  __int64 PerformanceCounter ;

  /* On first call, compute the performance rate.
   */
  if (!inited) {
    __int64 PerformanceFrequency ;

    QueryPerformanceFrequency((PLARGE_INTEGER) &PerformanceFrequency) ;
    PerformanceCounterTicksPerSecond = 1. / PerformanceFrequency ;
    inited = 1 ;
  }
    
  QueryPerformanceCounter((PLARGE_INTEGER) &PerformanceCounter);
  time = ((double) PerformanceCounter) * PerformanceCounterTicksPerSecond ;
  return time ;
}

#else /* PLARGE_INTEGER */

#include <sys/timeb.h>

static double gettimeofday(void)                /* ML */
{
  struct _timeb tb;
  double time ;
  _ftime(&tb);
  time = (double) tb.time + (double) tb.millitm / 1e3 ;
  return time ;
}

#endif /* PLARGE_INTEGER */

value skt_gettimeofday(value a_v) {               /* ML */
  value ret_v ;
  Push_roots(roots,1) ;
  roots[0] = a_v ;
  SKTTRACE ;

  ret_v = copy_double(gettimeofday()) ;
  modify(&Field(roots[0],0),ret_v) ;
  Pop_roots();
  return Val_unit ;
}

value skt_gettimeofday_native(value a_v) {               /* ML */
  SKTTRACE ;

  Store_double_field(a_v,0,gettimeofday()) ;
  return Val_unit ;
}

#endif
