(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* UNSIGNED: Unsigned, 16-byte MD5'd connection IDs. *)
(* Author: Mark Hayden, 3/97 *)
(**************************************************************)
open Trans
open Util
(**************************************************************)
let name = Trace.source_file "UNSIGNED"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)
  
let f =
  let (marshal,unmarshal) = Mbuf.make_marsh name Mbuf.global in

  let const hdlr kind rank = Route.Unsigned(hdlr kind rank) in

  let merge info =
    let upcalls = 
      Array.map (function 
      	| (_,_,_,Route.Unsigned u) -> u
      	| _ -> failwith "sanity"
      ) info 
    in
    Route.merge3f upcalls (fun upcall ->
      let pack = match info.(0) with (_,p,_,_) -> p in
      Route.info (fun () -> sprintf "unsigned:merge:%s" (hex_of_string pack)) ;
      let pack_s = String.copy pack in

      fun rbuf ofs len ->
	if len <| md5len + 8 then (
	  Route.drop (fun () -> sprintf "Unsigned:size below minimum:len=%d\n" len) ;
	) else (
	  let buf = Refcnt.read name rbuf in
	  String.blit buf ofs pack_s 0 md5len ;
	  if pack_s = pack then (
	    let mi    = Hsys.pop_int buf (ofs + md5len) in
	    let molen = Hsys.pop_int buf (ofs + md5len + 4) in
	    let ofs = ofs + md5len + 8 in
	    let len = len - md5len - 8 in
	    if molen =| 0 then (
	      let mv = Iovec.alloc name rbuf ofs len in
	      upcall mi None [| mv |] ;
	      Iovec.free name mv
	    ) else if len >| molen then (
	      let mo = Some(unmarshal buf ofs molen) in
	      let mv = Iovec.alloc name rbuf (ofs+molen) (len-molen) in
	      upcall mi mo [| mv |] ;
	      Iovec.free name mv
	    ) else if len =| molen then (
	      let mo = Some(unmarshal buf ofs molen) in
	      upcall mi mo [||]
	    ) else (
	      Route.drop (fun () -> sprintf "Unsigned:short message:len=%d:molen=%d\n" len molen) ;
	    )
	  ) else (
	    Route.drop (fun () -> sprintf "Unsigned:rest of Conn.id did not match") ;
	  )
	)
    )
  in

  let blast _ xmitv _ pack _ =
    Route.info (fun () -> sprintf "unsigned:blast:%s" (hex_of_string pack)) ;
    let ints_s = String.create 8 in
    let prefix = Iovec.of_string name (pack^ints_s) in
    let pack = Hsys.pop_int pack 0 in
    
    fun mi mo mv ->
      match mo with
      | None ->
      	  Iovec.write_hack name prefix (fun buf ofs len ->
	    Hsys.push_int buf (ofs+md5len) mi ;
	    Hsys.push_int buf (ofs+md5len+4) 0
	  ) ;
	  xmitv (Array.append [|prefix|] mv)
      | Some mo -> 
	  let mo = marshal mo in
      	  Iovec.write_hack name prefix (fun buf ofs len ->
	    Hsys.push_int buf (ofs+md5len) mi ;
	    Hsys.push_int buf (ofs+md5len+4) (Iovec.len name mo)
	  ) ;
	  xmitv (Array.append [|prefix;mo|] mv) ;
	  Iovec.free name mo
  in
  Route.make 
    name
    ident
    const
    Conn.hash_of_id 
    merge
    blast

(**************************************************************)
