(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SCALE: 16-byte MD5'd connection IDs. *)
(* Author: Mark Hayden, 3/97 *)
(**************************************************************)
open Trans
open Util
open Conn
open Route
open Transport
(**************************************************************)
let name = Trace.source_file "SCALE"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let f =
  let proc_conns l = 
    let l = List.map (fun (conn,kind,rank,dbg) ->
      (snd (Conn.squash_sender conn)),kind,(-1),dbg
    ) l 
    in
    Lset.collapse l
  in

  let conv_hdlr hdlr = fun kind _ -> hdlr kind in

  let id = Route.Scale in
  let pack_of_conn c =
    Conn.hash_of_id (snd (Conn.squash_sender c))
  in
  let (marsh,unmarsh) = Mbuf.make_marsh name Mbuf.global in

  let merge pos info =
    let upcalls = Array.map (fun (_,_,k,_,u) -> u k) info in
    let upcall = merge3 upcalls in
    Iovec.read_fun name (fun iov buf ofs len ->
      let mi    = Hsys.pop_int buf (ofs+pos) in
      let molen = Hsys.pop_int buf (ofs+pos+4) in
      if len < molen + pos + 8 then (
	eprintf "SCALE:molen=%d, len=%d\n" molen len ;
	failwith "short message"
      ) ;
      let ofs = ofs + pos + 8 in
      let len = len - pos - 8 in
      let mo  = 
	if molen = 0 then None else
	  Some(unmarsh buf ofs molen)
      in
      let mv = Iovec.sub name iov (ofs+molen) (len-molen) in
      let mv = [| mv |] in
      upcall mi mo mv
    )
  in
  
  let blast _ xmitv _ pack conn =
    let sender =
      let sender,_ = Conn.squash_sender conn in
      match sender with
      | Some rank -> rank
      |	None -> -1			(* hack! *)
    in

    let str = String.create 12 in
    Hsys.push_int str 0 (- (Route.int_of_id id)) ;
    let prefix = Iovec.of_string name (str^pack) in
    fun mo mv ->
      let mo = match mo with
      | None -> Iovec.empty name
      | Some obj -> marsh obj 
      in
      Iovec.write_hack name prefix (fun buf ofs len ->
	Hsys.push_int buf (ofs+4) sender ;
	Hsys.push_int buf (ofs+8) (Iovec.len name mo)
      ) ;
      xmitv (Array.append [|prefix;mo|] mv)
  in

  make
    Route.Scale
    proc_conns
    4 md5len
    pack_of_conn
    merge
    blast

let _ = 
  Trace.install_root (fun () -> [f.debug ()]) ;
  Transport.install f

(**************************************************************)
