(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* RAW router. *)
(* Author: Mark Hayden, 3/97 *)
(**************************************************************)
open Trans
open Util
(**************************************************************)
let name = Trace.source_file "RAW"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let f =
  let const hdlr kind rank = Route.Raw(hdlr kind rank) in

  let merge info =
    let upcalls = 
      Array.map (function 
      	| (_,_,_,Route.Raw u) -> u
      	| _ -> failwith "sanity"
      ) info 
    in
    Route.merge1f upcalls (fun upcall ->
      let pack = match info.(0) with (_,p,_,_) -> p in
      let pack_s = String.copy pack in

      fun rbuf ofs len ->
	let buf = Refcnt.read name rbuf in
	String.blit buf ofs pack_s 0 md5len ;
	if pack_s <> pack then (
	  Route.drop (fun () -> sprintf "Raw:rest of Conn.id did not match") ;
	) else (
	  let iov = Iovec.alloc name rbuf (ofs+md5len) (len-md5len) in
	  let iov = [| iov |] in
	  upcall iov
        )
    )
  in

  let blast _ xmitv _ pack _ =
    let prefix = Iovec.of_string name pack in
    fun iovs ->
      let iovs = Array.append [|prefix|] iovs in
      xmitv iovs
  in

  Route.make
    name
    ident
    const
    Conn.hash_of_id
    merge
    blast

(**************************************************************)
