(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* BYPASS: Optimized bypass router *)
(* Author: Mark Hayden, 3/97 *)
(**************************************************************)
open Trans
open Util
(**************************************************************)
let name = Trace.source_file "BYPASSR"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let f =
  let pack_of_conn conn =
    let pack = Conn.hash_of_id conn in
    String.sub pack 0 4
  in

  let const hdlr kind rank = Route.Bypass(hdlr kind rank) in

  let merge info =
    let upcalls = 
      Array.map (function 
      	| (_,_,_,Route.Bypass u) -> u
      	| _ -> failwith "sanity"
      ) info 
    in
    let upcall = Route.merge2 upcalls in
    fun rbuf ofs len ->
      let mi = Hsys.pop_int (Refcnt.read name rbuf) (ofs+4) in
      let mv = Iovec.alloc name rbuf (ofs+4+4) (len-4-4) in
      upcall mi mv
  in

  (* General purpose blast.
   *)
  let blast _ xmitv key pack conn =
    let prefix = String.create 8 in
    String.blit pack 0 prefix 0 4 ;
    let prefix = Iovec.of_string name prefix in
    (fun mi mv ->
      Iovec.write_hack name prefix (fun buf ofs len ->
	Hsys.push_int buf (ofs+4) mi
      ) ;
      xmitv [|prefix;mv|]
    )
  in

  (* Optimize single vector cases.
   *)
  let blast xmit xmitv key pack conn =
    let blast = blast xmit xmitv key pack conn in
    let scribble = String.create 8 in
    (fun mi mv ->
      Iovec.write_hack name mv (fun buf ofs len ->
	if ofs >= 8 then (
	  let ofs = ofs - 8 in
	  String.blit buf ofs scribble 0 8 ;
	  String.blit buf ofs pack 0 4 ;
	  Hsys.push_int buf (ofs+4) mi ;
	  xmit buf ofs (len+8) ;
	  String.blit scribble 0 buf ofs 8
	) else blast mi mv
      )
    )
  in

  Route.make 
    name
    ident
    const
    pack_of_conn
    merge
    blast

(**************************************************************)
