#*************************************************************#
#
#   Ensemble, (Version 0.40)
#   Copyright 1997 Cornell University
#   All rights reserved.
#
#   See ensemble/doc/license.txt for further information.
#
#*************************************************************#
# -*- Mode: makefile -*-
#*************************************************************#
#
# MAIN: primary makefile
#
# Author: Mark Hayden, 3/96
#
#*************************************************************#

.PHONY: all tk install depend clean crypto socket
.SUFFIXES: .gorp # no implicit rules (but some make's need one)

#*************************************************************#

main_all: $(OBJD) install $(ENS_OPTIONAL)

# Build support for Atm/Unet
atm: $(OBJD)/libatm$(CMA) $(OBJD)/libcatm$(ARC) $(ECP)
	$(ECPC) -o $(ENSLIB)/libatm $(OBJD)/libatm
	$(CP) $(OBJD)/libcatm$(ARC) $(ENSLIB)/libcatm$(ARC)
	ranlib $(ENSLIB)/libcatm$(ARC)

# Build crypto libraries
crypto: $(OBJD)/crypto$(CMA) $(OBJD)/libcryptoc$(ARC) $(ECP)
	$(ECPC) -o $(ENSLIB)/crypto $(OBJD)/crypto
	$(CP) $(OBJD)/libcryptoc$(ARC) $(ENSLIB)/libcryptoc$(ARC)
	ranlib $(ENSLIB)/libcryptoc$(ARC)

#*************************************************************#
# Installation dependencies.  These copy files into the lib
# directory.  The touches are for the dependency generators.

$(ENSLIB)/ensemble$(CMI): $(OBJD)/ensemble$(CMI)
	$(RM)	     $(ENSLIB)/ensemble.mli
	$(TOUCH)     $(ENSLIB)/ensemble.mli
	$(CHMOD) 000 $(ENSLIB)/ensemble.mli
	$(CP) $(OBJD)/ensemble$(CMI)	$(ENSLIB)

$(ENSLIB)/rpc$(CMI): $(OBJD)/rpc$(CMI)
	$(RM)	     $(ENSLIB)/rpc.mli
	$(TOUCH)     $(ENSLIB)/rpc.mli
	$(CHMOD) 000 $(ENSLIB)/rpc.mli
	$(CP) $(OBJD)/rpc$(CMI)		$(ENSLIB)

$(ENSLIB)/hsys$(CMI): $(OBJD)/hsys$(CMI)
	$(RM)	     $(ENSLIB)/hsys.mli
	$(TOUCH)     $(ENSLIB)/hsys.mli
	$(CHMOD) 000 $(ENSLIB)/hsys.mli
	$(CP) $(OBJD)/hsys$(CMI)	$(ENSLIB)

$(ENSLIB)/htk$(CMI): $(OBJD)/htk$(CMI)
	$(RM)	     $(ENSLIB)/htk.mli
	$(TOUCH)     $(ENSLIB)/htk.mli
	$(CHMOD) 000 $(ENSLIB)/htk.mli
	$(CP) $(OBJD)/htk$(CMI)		$(ENSLIB)

$(ENSLIB)/socket$(CMI): $(OBJD)/socket$(CMI)
	$(RM)	     $(ENSLIB)/socket.mli
	$(TOUCH)     $(ENSLIB)/socket.mli
	$(CHMOD) 000 $(ENSLIB)/socket.mli
	$(CP) $(OBJD)/socket$(CMI)	$(ENSLIB)

$(ENS): $(OBJD)/libens$(CMA) $(ECP)
	$(ECPC) -o $(ENSLIB)/libens $(OBJD)/libens

$(RPC): $(OBJD)/librpc$(CMA) $(ECP)
	$(ECPC) -o $(ENSLIB)/librpc $(OBJD)/librpc

$(ENSLIB)/libsock$(ARC): $(OBJD)/libsock$(ARC)
	$(CP) $(OBJD)/libsock$(ARC)	$(ENSLIB)

$(ENSTK): $(OBJD)/libhtk$(CMA) $(ECP)
	$(ECPC) -o $(ENSLIB)/libhtk $(OBJD)/libhtk

$(LIBUSOCK): $(OBJD)/usocket$(CMA) $(ECP)
	$(ECPC) -nocmi -nocmo -o $(ENSLIB)/usocket $(OBJD)/usocket

$(ENSLIB)/socket$(CMA): $(OBJD)/socket$(CMA) $(ECP)
	$(ECPC) -nocmi -nocmo -o $(ENSLIB)/socket $(OBJD)/socket

$(ENSLIB)/hot_ens.h: $(ENSROOT)/hot/include/hot_ens.h
	$(RM) $(ENSLIB)/hot_ens.h
	$(CP) $(ENSROOT)/hot/include/hot_ens.h		$(ENSLIB)
	-$(CHMOD) -f 666 $(ENSLIB)/hot_ens.h

$(ENSLIB)/hot_error.h: $(ENSROOT)/hot/include/hot_error.h
	$(RM) $(ENSLIB)/hot_error.h
	$(CP) $(ENSROOT)/hot/include/hot_error.h	$(ENSLIB)
	-$(CHMOD) -f 666 $(ENSLIB)/hot_error.h

$(ENSLIB)/hot_msg.h: $(ENSROOT)/hot/include/hot_msg.h
	$(RM) $(ENSLIB)/hot_msg.h
	$(CP) $(ENSROOT)/hot/include/hot_msg.h		$(ENSLIB)
	-$(CHMOD) -f 666 $(ENSLIB)/hot_msg.h

$(ENSLIB)/hot_sys.h: $(ENSROOT)/hot/include/hot_sys.h
	$(RM) $(ENSLIB)/hot_sys.h
	$(CP) $(ENSROOT)/hot/include/hot_sys.h		$(ENSLIB)
	-$(CHMOD) -f 666 $(ENSLIB)/hot_sys.h

$(ENSLIB)/hot_thread.h: $(ENSROOT)/hot/include/hot_thread.h
	$(RM) $(ENSLIB)/hot_thread.h
	$(CP) $(ENSROOT)/hot/include/hot_thread.h	$(ENSLIB)
	-$(CHMOD) -f 666 $(ENSLIB)/hot_thread.h

$(ENSLIB)/libhot$(ARC): $(OBJD)/libhot$(ARC)
	$(CP) $(OBJD)/libhot$(ARC)	$(ENSLIB)

#*************************************************************#
# These are special dependencies for installing the libraries
# in the lib directory and for building the socket library.
# Build socket library.

install: \
	$(ENSLIB)/libens$(CMA)	\
	$(ENSLIB)/ensemble$(CMI)	\
	$(ENSLIB)/rpc$(CMI)		\
	$(ENSLIB)/hsys$(CMI)		\
	$(ENSLIB)/librpc$(CMA)		\
	$(ENSLIB)/socket$(CMI)		\
	$(ENSLIB)/socket$(CMA)	\
	$(HSYS_BUILD)

# Build & install C portion of Socket library
socket:	$(OBJD) $(ENSLIB)/socket$(CMA) $(ENSLIB)/libsock$(ARC)

# Build & install Tk libraries
tk: $(OBJD) $(ENSLIB)/htk$(CMI) $(ENSTK)

#*************************************************************#
# A rule for the object directory

$(OBJD):
	mkdir $(OBJD)

#*************************************************************#
# RvR's RPC support

RPCOBJ = \
	$(OBJD)/xlist$(CMO)	\
	$(OBJD)/scanf$(CMO)	\
	$(OBJD)/eval$(CMO)	\
	$(OBJD)/sockio$(CMO)	\
	$(OBJD)/rpc$(CMO)

#*************************************************************#
# These are the modules exported from appl/ensemble.ml

ENSEMBLECMI = \
	$(OBJD)/hsys$(CMI)	\
	$(OBJD)/trace$(CMI)	\
	$(OBJD)/trans$(CMI)	\
	$(OBJD)/iovec$(CMI)	\
	$(OBJD)/iovecl$(CMI)	\
	$(OBJD)/lset$(CMI)	\
	$(OBJD)/time$(CMI)	\
	$(OBJD)/addr$(CMI)	\
	$(OBJD)/endpt$(CMI)	\
	$(OBJD)/group$(CMI)	\
	$(OBJD)/param$(CMI)	\
	$(OBJD)/view$(CMI)	\
	$(OBJD)/domain$(CMI)	\
	$(OBJD)/alarm$(CMI)	\
	$(OBJD)/util$(CMI)	\
	$(OBJD)/proto$(CMI)	\
	$(OBJD)/stack_id$(CMI)	\
	$(OBJD)/conn$(CMI)	\
	$(OBJD)/arge$(CMI)	\
	$(OBJD)/sched$(CMI)	\
	$(OBJD)/appl_intf$(CMI)	\
	$(OBJD)/event$(CMI)	\
	$(OBJD)/stacke$(CMI)	\
	$(OBJD)/mbuf$(CMI)	\
	$(OBJD)/security$(CMI)	\
	$(OBJD)/shared$(CMI)	\
	$(OBJD)/property$(CMI)	\
	$(OBJD)/transport$(CMI)	\
	$(OBJD)/hsyssupp$(CMI)	\
	$(OBJD)/auth$(CMI)	\
	$(OBJD)/timestamp$(CMI)	\
	$(OBJD)/manage$(CMI)	\
	$(OBJD)/proxy$(CMI)	\
	$(OBJD)/reflect$(CMI)	\
	$(OBJD)/raw$(CMI)	\
	$(OBJD)/bypassr$(CMI)	\
	$(OBJD)/signed$(CMI)	\
	$(OBJD)/unsigned$(CMI)	\
	$(OBJD)/debug$(CMI)	\
	$(OBJD)/appl$(CMI)

#*************************************************************#
# These are the modules exported from appl/ensemble.ml

ENSEMBLEMLI = \
	$(ENSROOT)/util/trace.mli	\
	$(ENSROOT)/util/trans.mli	\
	$(ENSROOT)/util/util.mli	\
	$(ENSROOT)/util/lset.mli	\
	$(ENSROOT)/util/iovec.mli	\
	$(ENSROOT)/util/iovecl.mli	\
	$(ENSROOT)/util/timestamp.mli	\
	$(ENSROOT)/util/mbuf.mli	\
	$(ENSROOT)/util/sched.mli	\
	$(ENSROOT)/type/time.mli	\
	$(ENSROOT)/type/addr.mli	\
	$(ENSROOT)/type/endpt.mli	\
	$(ENSROOT)/type/group.mli	\
	$(ENSROOT)/type/param.mli	\
	$(ENSROOT)/type/proto.mli	\
	$(ENSROOT)/type/auth.mli	\
	$(ENSROOT)/type/security.mli	\
	$(ENSROOT)/type/shared.mli	\
	$(ENSROOT)/type/view.mli	\
	$(ENSROOT)/type/domain.mli	\
	$(ENSROOT)/type/alarm.mli	\
	$(ENSROOT)/type/stack_id.mli	\
	$(ENSROOT)/type/conn.mli	\
	$(ENSROOT)/type/appl_intf.mli	\
	$(ENSROOT)/type/event.mli	\
	$(ENSROOT)/type/property.mli	\
	$(ENSROOT)/infr/transport.mli	\
	$(ENSROOT)/infr/hsyssupp.mli	\
	$(ENSROOT)/infr/stacke.mli	\
	$(ENSROOT)/infr/panel.mli	\
	$(ENSROOT)/appl/maestro/proxy.mli	\
	$(ENSROOT)/appl/maestro/manage.mli	\
	$(ENSROOT)/appl/reflect.mli	\
	$(ENSROOT)/appl/arge.mli	\
	$(ENSROOT)/appl/debug.mli	\
	$(ENSROOT)/appl/appl.mli	\
	$(ENSROOT)/route/raw.mli	\
	$(ENSROOT)/route/bypassr.mli	\
	$(ENSROOT)/route/signed.mli	\
	$(ENSROOT)/route/unsigned.mli

#*************************************************************#
# Utility Stuff

UTILOBJ = \
	$(OBJD)/printe$(CMO)	\
	$(OBJD)/queuee$(CMO)	\
	$(OBJD)/fqueue$(CMO)	\
	$(OBJD)/util$(CMO)	\
	$(OBJD)/arrayop$(CMO)	\
	$(OBJD)/deepcopy$(CMO)	\
	$(OBJD)/trace$(CMO)	\
	$(OBJD)/lset$(CMO)	\
	$(OBJD)/once$(CMO)	\
	$(OBJD)/iq$(CMO)	\
	$(OBJD)/handler$(CMO)	\
	$(OBJD)/mcredit$(CMO)	\
	$(OBJD)/request$(CMO)	\
	$(OBJD)/priq$(CMO)	\
	$(OBJD)/resource$(CMO)	\
	$(OBJD)/sched$(CMO)	\
	$(OBJD)/trans$(CMO)	\
	$(OBJD)/refcnt$(CMO)	\
	$(OBJD)/iovec$(CMO)	\
	$(OBJD)/iovecl$(CMO)	\
	$(OBJD)/compresse$(CMO)	\
	$(OBJD)/marsh$(CMO)	\
	$(OBJD)/mbuf$(CMO)	\
	$(OBJD)/timestamp$(CMO)	\

#	$(OBJD)/tree$(CMO)	\
#*************************************************************#
# Ensemble Abstract Types

TYPEOBJ = \
	$(OBJD)/shared$(CMO)	\
	$(OBJD)/time$(CMO)	\
	$(OBJD)/addr$(CMO)	\
	$(OBJD)/version$(CMO)	\
	$(OBJD)/proto$(CMO)	\
	$(OBJD)/stack_id$(CMO)	\
	$(OBJD)/unique$(CMO)	\
	$(OBJD)/endpt$(CMO)	\
	$(OBJD)/group$(CMO)	\
	$(OBJD)/security$(CMO)	\
	$(OBJD)/auth$(CMO)	\
	$(OBJD)/param$(CMO)	\
	$(OBJD)/view$(CMO)	\
	$(OBJD)/conn$(CMO)	\
	$(OBJD)/alarm$(CMO)	\
	$(OBJD)/domain$(CMO)	\
	$(OBJD)/event$(CMO)	\
	$(OBJD)/route$(CMO)	\
	$(OBJD)/typedescr$(CMO)	\
	$(OBJD)/layer$(CMO)	\
	$(OBJD)/property$(CMO)	\
	$(OBJD)/appl_intf$(CMO)

#*************************************************************#
# Ensemble Routers

ROUTEOBJ = \
	$(OBJD)/bypassr$(CMO)	\
	$(OBJD)/raw$(CMO)	\
	$(OBJD)/unsigned$(CMO)	\
	$(OBJD)/signed$(CMO)

#	$(OBJD)/scale$(CMO) \
#*************************************************************#
# Ensemble Infrastructure

INFROBJ = \
	$(OBJD)/transport$(CMO)	\
	$(OBJD)/async$(CMO)	\
	$(OBJD)/hsyssupp$(CMO)	\
	$(OBJD)/config_trans$(CMO) \
	$(OBJD)/glue$(CMO)	\
	$(OBJD)/disp$(CMO)	\
	$(OBJD)/panel$(CMO)

#*************************************************************#
# Application Support

APPLOBJ = \
	$(OBJD)/debug$(CMO)	\
	$(OBJD)/arge$(CMO)	\
	$(OBJD)/proxy$(CMO)	\
	$(OBJD)/actual$(CMO)	\
	$(OBJD)/manage$(CMO)	\
	$(OBJD)/stacke$(CMO)	\
	$(OBJD)/appl$(CMO)	\
	$(OBJD)/reflect$(CMO)	\
	$(OBJD)/pgp$(CMO)

#	$(OBJD)/atomic$(CMO)	\
#	$(OBJD)/link_config$(CMO) \
#*************************************************************#
# Transport & Alarm modules

TRANSOBJ = \
	$(OBJD)/real$(CMO)	\
	$(OBJD)/netsim$(CMO)	\
	$(OBJD)/ipmc$(CMO)	\
	$(OBJD)/udp$(CMO)	\
	$(OBJD)/tcp$(CMO)

#	$(OBJD)/threaded$(CMO)	\
#*************************************************************#
# Layers

LAYERSOBJ = \
	$(OBJD)/stable$(CMO)	\
	$(OBJD)/bottom$(CMO)	\
	$(OBJD)/mnak$(CMO)	\
	$(OBJD)/pt2pt$(CMO)	\
\
	$(OBJD)/suspect$(CMO)	\
	$(OBJD)/merge$(CMO)	\
	$(OBJD)/inter$(CMO)	\
	$(OBJD)/intra$(CMO)	\
	$(OBJD)/elect$(CMO)	\
	$(OBJD)/leave$(CMO)	\
	$(OBJD)/sync$(CMO)	\
	$(OBJD)/slander$(CMO)	\
\
	$(OBJD)/heal$(CMO)	\
	$(OBJD)/switch$(CMO)	\
	$(OBJD)/exchange$(CMO)	\
\
	$(OBJD)/top_appl$(CMO)	\
	$(OBJD)/top$(CMO)	\
	$(OBJD)/local$(CMO)	\
	$(OBJD)/cltsvr$(CMO)	\
	$(OBJD)/frag$(CMO)	\
	$(OBJD)/xfer$(CMO)	\
	$(OBJD)/subcast$(CMO)	\
	$(OBJD)/migrate$(CMO)	\
	$(OBJD)/encrypt$(CMO)	\
	$(OBJD)/rekey$(CMO)	\
	$(OBJD)/primary$(CMO)	\
\
	$(OBJD)/rate$(CMO)	\
	$(OBJD)/window$(CMO)	\
	$(OBJD)/credit$(CMO)	\
	$(OBJD)/pt2ptw$(CMO)	\
	$(OBJD)/mflow$(CMO)	\
\
	$(OBJD)/total$(CMO)	\
	$(OBJD)/totem$(CMO)	\
	$(OBJD)/sequencer$(CMO)	\
	$(OBJD)/tops$(CMO)	\
\
	$(OBJD)/assert$(CMO)	\
	$(OBJD)/delay$(CMO)	\
	$(OBJD)/drop$(CMO)	\
	$(OBJD)/chk_fifo$(CMO)	\
	$(OBJD)/chk_total$(CMO)	\
	$(OBJD)/chk_sync$(CMO)	\
\
	$(OBJD)/pr_stable$(CMO)	\
	$(OBJD)/pr_suspect$(CMO) \
	$(OBJD)/gcast$(CMO)	\
	$(OBJD)/pbcast$(CMO)	\

#	$(OBJD)/chk_causal$(CMO) \
#	$(OBJD)/chk_hi_causal$(CMO) \
#	$(OBJD)/evs$(CMO)	\
#	$(OBJD)/smq$(CMO)	\
#	$(OBJD)/dag$(CMO)	\
#	$(OBJD)/tcausal$(CMO)	\
#	$(OBJD)/agree$(CMO)	\
#	$(OBJD)/tsync$(CMO)
#	$(OBJD)/tleave$(CMO)	\
#	$(OBJD)/bypass$(CMO)	\
#	$(OBJD)/safe$(CMO)
#	$(OBJD)/bypfifo$(CMO)	\
#	$(OBJD)/side$(CMO)	\
#	$(OBJD)/chk_merge$(CMO)	\
#*************************************************************#
# Socket library

SOCKOBJ = \
	$(OBJD)/socket$(CMO)

SOCKCOBJ = \
	$(OBJD)/marshal$(OBJ)	\
	$(OBJD)/static_string$(OBJ) \
	$(OBJD)/fork$(OBJ)	\
	$(OBJD)/gettimeofday$(OBJ) \
	$(OBJD)/multicasts$(OBJ) \
	$(OBJD)/poll$(OBJ)	\
	$(OBJD)/pushint$(OBJ)	\
	$(OBJD)/select$(OBJ)	\
	$(OBJD)/sendopt$(OBJ)	\
	$(OBJD)/sockfd$(OBJ)	\
	$(OBJD)/sockopt$(OBJ)	\
	$(OBJD)/spawn$(OBJ)	\
	$(OBJD)/sendrecv$(OBJ)	\
	$(OBJD)/stdin$(OBJ)

#*************************************************************#
# ATM Files

ATMOBJ = \
	$(OBJD)/atm$(CMO)

ATMCOBJ = \
	$(OBJD)/atm_unet$(OBJ)	\
	$(OBJD)/atm_ocaml$(OBJ)

#*************************************************************#
# Crypto Stuff

CRYPTOOBJ = \
	$(OBJD)/des$(CMO)

CRYPTOCOBJ = \
	$(OBJD)/des_c$(OBJ)

#*************************************************************#
# HOT files

HOTCOBJ = \
	$(OBJD)/hot_c$(OBJ)	\
	$(OBJD)/hot_mem$(OBJ)	\
	$(OBJD)/hot_error$(OBJ)	\
	$(OBJD)/hot_sys$(OBJ)	\
	$(OBJD)/hot_msg$(OBJ)	\
	$(OBJD)/$(HOT_THREAD_OBJ) # see config.mk

#*************************************************************#
# Make libraries and global interface files The NTRULE and
# UNIXRULE are defined so that the appropriate version is
# used for Unix and for NT.

ENSOBJ = $(UTILOBJ) $(TYPEOBJ) $(ROUTEOBJ) $(INFROBJ) $(APPLOBJ) $(LAYERSOBJ) $(TRANSOBJ)

$(OBJD)/libens$(CMA)$(UNIXRULE): $(OBJD)/hsys$(CMO) $(ENSOBJ) $(OBJD)/ensemble$(CMO)
	$(MLLIBR) -o $(OBJD)/libens$(CMA) -linkall $(OBJD)/hsys$(CMO) $(ENSOBJ) $(OBJD)/ensemble$(CMO)

# The Nt makefile program doesn't like long lines

$(OBJD)/libens$(CMA)$(NTRULE): $(OBJD)/hsys$(CMO) $(ENSOBJ) $(OBJD)/ensemble$(CMO) $(ELONG)
	$(ECHO) $(OBJD)/hsys$(CMO) $(UTILOBJ) >$(OBJD)/util.files
	$(ECHO) $(TYPEOBJ)	>$(OBJD)/type.files
	$(ECHO) $(ROUTEOBJ)	>$(OBJD)/route.files
	$(ECHO) $(INFROBJ)	>$(OBJD)/infr.files
	$(ECHO) $(APPLOBJ)	>$(OBJD)/appl.files
	$(ECHO) $(LAYERSOBJ)	>$(OBJD)/layers.files
	$(ECHO) $(TRANSOBJ) $(OBJD)/ensemble$(CMO) >$(OBJD)/trans.files
	$(ELONGC) 7 \
	  $(OBJD)/util.files \
	  $(OBJD)/type.files \
	  $(OBJD)/route.files \
	  $(OBJD)/infr.files \
	  $(OBJD)/appl.files \
	  $(OBJD)/layers.files \
	  $(OBJD)/trans.files \
	  $(MLLIBR) -o $(OBJD)/libens$(CMA) -linkall

$(OBJD)/librpc$(CMA): $(RPCOBJ)
	$(MLLIBR) -o $(OBJD)/librpc$(CMA) -linkall $(RPCOBJ)

$(OBJD)/libhtk$(CMA): $(OBJD)/htk$(CMO)
	$(MLLIBR) -o $(OBJD)/libhtk$(CMA) -linkall $(OBJD)/htk$(CMO)

$(OBJD)/socket$(CMA): $(SOCKOBJ)
	$(MLLIBR) -o $(OBJD)/socket$(CMA) -linkall $(SOCKOBJ)

$(OBJD)/usocket$(CMA): $(OBJD)/usocket$(CMO)
	$(MLLIBR) -o $(OBJD)/usocket$(CMA) -linkall $(OBJD)/usocket$(CMO)

$(OBJD)/libatm$(CMA): $(ATMOBJ)
	$(MLLIBR) -o $(OBJD)/libatm$(CMA) -linkall $(ATMOBJ)

$(OBJD)/libcatm$(ARC): $(ATMCOBJ)
	$(CP) $(LIBUNET) $(OBJD)/libcatm$(ARC)
	$(MKLIB) $(MKLIBO)$(OBJD)/libcatm$(ARC) $(ATMCOBJ)
	$(RANLIB) $(OBJD)/libcatm$(ARC)

$(OBJD)/libsock$(ARC): $(SOCKCOBJ)
	$(MKLIB) $(MKLIBO)$(OBJD)/libsock$(ARC) $(SOCKCOBJ)
	$(RANLIB) $(OBJD)/libsock$(ARC)

$(OBJD)/crypto$(CMA): $(CRYPTOOBJ)
	$(MLLIBR) -o $(OBJD)/crypto$(CMA) -linkall $(CRYPTOOBJ)

$(OBJD)/libcryptoc$(ARC): $(LIBUNET) $(CRYPTOCOBJ)
	$(MKLIB) $(MKLIBO)$(OBJD)/libcryptoc$(ARC) $(CRYPTOCOBJ)
	$(RANLIB) $(OBJD)/libcryptoc$(ARC)

#*************************************************************#
# Create a version of the socket library that uses the Unix
# library.  This is so that on Unix platforms, users do not
# need to compile any C code in order to get started.

$(OBJD)/us:
	mkdir -p $(OBJD)/us

$(OBJD)/usocket$(CMO): $(OBJD)/us	\
	  $(ECAMLC) $(EMV)		\
	  $(OBJD)/socket$(CMI)		\
	  $(ENSROOT)/socket/_usocket.ml
	$(RM) $(OBJD)/us/socket.ml
	$(RM) $(OBJD)/us/socket$(CMI)
	$(CP) $(ENSROOT)/socket/_usocket.ml $(OBJD)/us/socket.ml
	$(CP) $(OBJD)/socket$(CMI) $(OBJD)/us/socket$(CMI)
	$(TOUCH) $(OBJD)/us/socket.mli
	$(ECAMLCC) -o $(OBJD)/us $(ENSCOMPFLAGS) $(OBJD)/us/socket.ml
	$(EMVC) -nocmi -o $(OBJD)/usocket $(OBJD)/us/socket

#*************************************************************#
# "Cross-compile" for the Nt Unix library These rules only run 
# under Unix, and only from the ensemble/def directory.

cross: $(OBJD)/nt $(ECP) $(OBJD)/nt/socket.cma $(OBJD)/nt/libens$(CMA)
	ocamlrun $(ECP) -nocmo -nocmi -o $(ENSLIB)/libens-nt $(OBJD)/nt/libens
	ocamlrun $(ECP) -nocmo -nocmi -o $(ENSLIB)/socket-nt $(OBJD)/nt/socket

$(OBJD)/nt: $(OBJD)
	mkdir -p $(OBJD)/nt

$(OBJD)/nt/unix.mli: $(LIBNTUNIX)/unix.mli
	$(CP) $(LIBNTUNIX)/unix.mli $(OBJD)/nt/unix.mli

$(OBJD)/nt/unix$(CMI): $(OBJD)/nt $(OBJD)/nt/unix.mli
	cd $(OBJD)/nt ; $(MLCOMP) -c unix.mli

$(OBJD)/nt/hsys$(CMI): $(OBJD)/hsys$(CMI)
	$(CP) $(ENSROOT)/util/hsys.mli $(OBJD)/nt/hsys.mli
	$(CP) $(OBJD)/hsys$(CMI) $(OBJD)/nt/hsys$(CMI)

$(OBJD)/nt/socket.cma: \
	  $(EMV) \
	  $(OBJD)/nt \
	  $(OBJD)/socket$(CMI) \
	  $(OBJD)/nt/unix$(CMI) \
	  $(ENSROOT)/socket/socket.ml
	$(CP) $(ENSROOT)/socket/socket.ml  $(OBJD)/nt/socket.ml
	$(CP) $(ENSROOT)/socket/socket.mli $(OBJD)/nt/socket.mli
	$(CP) $(OBJD)/socket$(CMI)	   $(OBJD)/nt/socket$(CMI)
	cd $(OBJD)/nt ; $(MLCOMP) -c socket.ml
	$(MLLIBR) -o $(OBJD)/nt/socket.cma -linkall $(OBJD)/nt/socket.cmo

$(OBJD)/nt/hsys.cmo: \
	  $(EMV) \
	  $(OBJD)/nt \
	  $(OBJD)/nt/hsys$(CMI) \
	  $(OBJD)/nt/unix$(CMI) \
	  $(OBJD)/nt/socket$(CMA) \
	  $(ENSROOT)/util/hsys.ml
	$(CP) $(ENSROOT)/util/hsys.ml $(OBJD)/nt/hsys.ml
	cd $(OBJD)/nt ; $(MLCOMP) -c hsys.ml

$(OBJD)/nt/libens$(CMA): $(OBJD)/nt/hsys$(CMO) $(ENSOBJ) $(OBJD)/ensemble$(CMO)
	$(MLLIBR) -o $(OBJD)/nt/libens$(CMA) -linkall $(OBJD)/nt/hsys$(CMO) $(ENSOBJ) $(OBJD)/ensemble$(CMO)

#*************************************************************#
# ensemble.mli is generated from exported .mli files

$(OBJD)/ensemble.mli: $(ENSEMBLEMLI) $(EMRG)
	$(RM) $(OBJD)/ensemble.mli
	$(EMRGC) $(ENSEMBLEMLI) > $(OBJD)/ensemble.mli
	$(CHMOD) -w $(OBJD)/ensemble.mli

$(OBJD)/ensemble.ml: $(ENSROOT)/ensemble.ml
	$(RM) $(OBJD)/ensemble.ml
	$(CP) $(ENSROOT)/ensemble.ml $(OBJD)/ensemble.ml
	$(CHMOD) -w $(OBJD)/ensemble.ml

$(OBJD)/ensemble$(CMO): $(OBJD)/ensemble.ml $(OBJD)/ensemble$(CMI) $(ENSOBJ)
	$(ENSCOMP) $(OBJD)/ensemble.ml

$(OBJD)/ensemble$(CMI): $(OBJD)/ensemble.mli
	$(ENSCOMP) $(OBJD)/ensemble.mli

#*************************************************************#

$(OBJD)/rpc$(CMI): $(OBJD)/rpc$(CMO)

#*************************************************************#
# Libhot compilation rules

libhot: $(OBJD) $(ENSLIB)/libhot$(ARC) hot_test \
	$(ENSLIB)/hot_ens.h	\
	$(ENSLIB)/hot_error.h	\
	$(ENSLIB)/hot_msg.h	\
	$(ENSLIB)/hot_sys.h	\
	$(ENSLIB)/hot_thread.h

# Create an object file containing the ML code
$(OBJD)/hot$(OBJ): $(OBJD)/gctx$(CMO) $(OBJD)/hot_ml$(CMO) $(ENSCONFDEP)
	$(RM) hot-$(PLATFORM).c
	$(MLCOMP) -output-obj -o hot$(OBJ) $(ENSCONF) $(OBJD)/gctx$(CMO) $(OBJD)/hot_ml$(CMO) $(HOT_MLLINK)
	$(RM) $(OBJD)/hot$(OBJ)
	$(MV) hot$(OBJ) $(OBJD)/hot$(OBJ)

# Put all the libraries, ML code, and runtime into one library
$(OBJD)/libhot$(ARC): $(HOTCOBJ) $(OBJD)/hot$(OBJ) $(OBJD)/libsock$(ARC)
	$(PARTIALLD) $(PARTIALLDO) $(OBJD)/libhot$(OBJ) \
	  $(OBJD)/hot$(OBJ)	\
	  $(HOTCOBJ)		\
	  $(OBJD)/libsock$(ARC)	\
	  $(OCAML_LIB)/libunix$(ARCS) \
	  $(MLRUNTIME)
	$(MKLIB) $(MKLIBO)$(OBJD)/libhot$(ARC) $(OBJD)/libhot$(OBJ)
	$(RANLIB) $(OBJD)/libhot$(ARC)

# Generate the hot_test executable
hot_test$(UNIXRULE): $(OBJD)/libhot$(ARC) $(OBJD)/hot_test$(OBJ)
	$(CC) -g -o $(ENSROOT)/demo/hot_test$(EXE) \
	  $(OBJD)/hot_test$(OBJ) \
	  $(OBJD)/libhot$(ARC) \
	  $(HOT_LINK)

# Purified version of hot_test
phot_test: $(OBJD)/libhot$(ARC) $(OBJD)/hot_test$(OBJ)
	purify $(CC) -g -o $(ENSROOT)/demo/hot_test$(EXE) \
	  $(OBJD)/hot_test$(OBJ) \
	  $(OBJD)/libhot$(ARC) \
	  $(HOT_LINK)

#*************************************************************#
# Nt version of the hot_test

hot_test$(NTRULE): $(OBJD)/libhot$(ARC) $(OBJD)/hot_test$(OBJ) $(OBJD)\libsock$(ARC)
	cl \
	  $(OBJD)/hot_test$(OBJ) \
	  $(OBJD)/libhot$(ARC) \
	  $(MLRUNTIME) \
	  $(OCAML_LIB)/libunix$(ARCS) \
	  $(OBJD)/libsock$(ARC) \
	  $(LIBSYSCL)
	$(RM) $(ENSROOT)/demo/hot_test$(EXE)
	$(MV) hot_test-nt$(EXE) $(ENSROOT)/demo/hot_test$(EXE)

#*************************************************************#
# The ATM transport C file requires special header files

$(OBJD)/atm_unet$(OBJ) : $(ENSROOT)/atm/atm_unet.c
	$(CC) -o $(OBJD)/atm_unet$(OBJ) $(CFLAGS) -c $(INCUNET) $(ENSROOT)/atm/atm_unet.c

#*************************************************************#
# Special compiler, dependency generators, and other tools

$(ECAMLDEP): ../tools/ecamldep.mll ../tools/misc.ml
	$(RM) $(OBJD)/ecamldep.mll
	$(RM) $(OBJD)/ecamldep.ml
	$(CP) ../tools/ecamldep.mll $(OBJD)/ecamldep.mll
	$(RM) $(OBJD)/misc.ml
	$(CP) ../tools/misc.ml $(OBJD)/misc.ml
	ocamllex $(OBJD)/ecamldep.mll
	ocamlc -I $(OBJD) -o $(ECAMLDEP) $(OBJD)/misc.ml $(OBJD)/ecamldep.ml

$(OBJD)/mkutil.ml: ../tools/mkutil.ml
	$(RM) $(OBJD)/mkutil.ml
	$(CP) ../tools/mkutil.ml $(OBJD)/mkutil.ml

$(ECAMLC): ../tools/ecamlc.ml $(OBJD)/mkutil.ml
	$(RM) $(OBJD)/ecamlc.ml
	$(CP) ../tools/ecamlc.ml $(OBJD)/ecamlc.ml
	ocamlc -I $(OBJD) -o $(ECAMLC) $(OBJD)/mkutil.ml $(OBJD)/ecamlc.ml

$(EMV): ../tools/emv.ml $(OBJD)/mkutil.ml
	$(RM) $(OBJD)/emv.ml
	$(CP) ../tools/emv.ml $(OBJD)/emv.ml
	ocamlc -I $(OBJD) -o $(EMV) $(OBJD)/mkutil.ml $(OBJD)/emv.ml

$(ECP): ../tools/ecp.ml $(OBJD)/mkutil.ml
	$(RM) $(OBJD)/ecp.ml
	$(CP) ../tools/ecp.ml $(OBJD)/ecp.ml
	ocamlc -I $(OBJD) -o $(ECP) $(OBJD)/mkutil.ml $(OBJD)/ecp.ml

$(EMRG): ../tools/emrg.ml $(OBJD)/mkutil.ml
	$(RM) $(OBJD)/emrg.ml
	$(CP) ../tools/emrg.ml $(OBJD)/emrg.ml
	ocamlc -I $(OBJD) -o $(EMRG) $(OBJD)/mkutil.ml $(OBJD)/emrg.ml

$(ELONG): ../tools/elong.ml $(OBJD)/mkutil.ml
	$(RM) $(OBJD)/elong.ml
	$(CP) ../tools/elong.ml $(OBJD)/elong.ml
	ocamlc -I $(OBJD) -o $(ELONG) $(OBJD)/mkutil.ml $(OBJD)/elong.ml

#*************************************************************#

clean:
	$(RM) *~ .*~ *.[oa] core .err gmon.out mon.out
	$(RM) -r $(OBJD)
	mkdir $(OBJD)

realclean: clean

#*************************************************************#

SRCDIRS = util appl route appl/maestro infr trans type atm rpc socket hot \
  layers/trans layers/other layers/flow layers/bypass	 \
  layers/total layers/gossip layers/debug layers/vsync	 \
  layers/transis layers/scale crypto

depend: $(OBJD) $(ECAMLDEP)
	$(ECAMLDEPC) $(DEPFLAGS)	\
	  -com '$$(ENSCOMP)'		\
	  -depend '$$(ECAMLC)'		\
	  -I $(ENSROOT)/hsys		\
	  $(SRCDIRS:%=-I $(ENSROOT)/%)	\
	  $(ENSROOT)/socket/*.c		\
	  $(ENSROOT)/hot/*.c		\
	  $(ENSROOT)/crypto/*.c		\
	  $(ENSROOT)/atm/atm_ocaml.c	\
	  $(SRCDIRS:%=$(ENSROOT)/%/*.mli) \
	  $(SRCDIRS:%=$(ENSROOT)/%/*.ml) > $(DEPEND)

#*************************************************************#
