#*************************************************************#
#
#   Ensemble, (Version 0.40)
#   Copyright 1997 Cornell University
#   All rights reserved.
#
#   See ensemble/doc/license.txt for further information.
#
#*************************************************************#
# -*- Mode: makefile -*- 
#*************************************************************#
#
# CONFIG: This set of definitions is included at the beginning
# of the makefiles to define configurable compilation
# parameters.  For Unix.
#
# Author: Mark Hayden, Robbert vanRenesse, 4/96
#
#*************************************************************#
# C Compilation macros.  Used for compiling Socket library
# and the C interface.  Ensemble has been compiled with gcc
# and acc on SunOS4, Solaris, and Aix.  With cl on Nt.

# C compiler to use
CC	= gcc

# CFLAGS: used for compilation of C files
CFLAGS	= -O -g \
	-I $(OCAML_LIB)/caml		\
	-I $(ENSROOT)/hot/include	\
	$(HOT_CFLAGS) $(CRYPTO_INC)	\
	-DHAS_SENDMSG

# LIBSYS: used for linking executables
LIBSYS	= # default for Unix is nothing

# SHELL to use for processing these makefiles must be /bin/sh
SHELL = /bin/sh









#*************************************************************#
# Arguments to use for linking with CamlTk.  You may need to
# add "-ccopt -Ldir" arguments).  Only worry about these if
# you are compiling a graphical application, such as WBML.
# Note that you must use tk4.0 and tcl7.4.

# for Cornell CS Dept
#TKLIBS = \
#	-cclib -lcamltk4 \
#	-cclib -ltk	\
#	-cclib -ltcl	\
#	-cclib -lX11

TKLIBS = \
	-cclib -lcamltk4 \
	-cclib -ltk4.0	\
	-cclib -ltcl7.4	\
	-ccopt -L/usr/local/X11R6/lib \
	-cclib -lX11

#*************************************************************#
# PLATFORM describes the Unix platform you are using.  This
# is used to differentiate machine dependent files.  On Unix
# platforms (without the Socket library) there are no
# machine-dependent files for the bytecode version of
# Ensemble, so these do not need to be set.  The default is
# to use the GNU "standards" of machine_name-os_name.  If
# you are using the tcsh shell, then the environment
# variables MACHTYPE and OSTYPE will be set correctly for
# your platform and you can use the defaults.  On Nt,
# PLATFORM should be set to be Nt.

# MACHTYPE = # type of machine: sparc, i386, rs6000, ...
# OSTYPE = # os: sunos4, solaris, aix
PLATFORM	= $(MACHTYPE)-$(OSTYPE)

#*************************************************************#
#*************************************************************#
# FOR INITIAL CONFIGURATION, NOTHING BELOW HERE SHOULD NEED TO
# BE EDITED.
#*************************************************************#
#*************************************************************#

#*************************************************************#
# There are three different configurations of Ensemble.  For
# Unix, the default is to use the Unix library.  For Nt,
# only the socket library is supported.  HSYS_BUILD
# determines which configurations should be built.
# ENSCONFDEP is the set of Ensemble system modules being
# used.  ENSCONF also includes O'caml modules and specifies
# whether -custom flag should be used.

HSYS_TYPE = unix

# Socket library
HSYS_BUILD_skt	= socket
ENSCONFDEP_skt	= $(LIBSOCKDEP) $(ENS)
ENSCONF_skt	= $(CUSTOM) $(LIBUNIX) $(LIBSOCK) $(LINK_THR) $(ENS)

# Unix library
HSYS_BUILD_unix	= $(LIBUSOCK)
ENSCONFDEP_unix	= $(LINKTHR) $(LIBUSOCK) $(ENS)
ENSCONF_unix    = $(CUSTOM) $(LIBUNIX) $(LIBUSOCK) $(LINK_THR) $(ENS)

HSYS_BUILD	= $(HSYS_BUILD_$(HSYS_TYPE))
ENSCONF		= $(ENSCONF_$(HSYS_TYPE))
ENSCONFDEP      = $(ENSCONFDEP_$(HSYS_TYPE))

#*************************************************************#
# OCAML_LIB should point to the library directory.  For
# Unix, OCAML_LIB is only necessary for the socket library
# and the C interface.  By default, it is set to the value
# of the environment variable CAMLLIB, which normally is set
# to the O'Caml library directory.  It is usually preferable
# to set OCAML_LIB indirectly through the CAMLLIB
# environment variable.  Be careful, $(OCAML_LIB)/caml needs
# to identify the correct location of the config.h header
# file.  A copy may also be found in ocaml/byterun, but you
# do not want to use that version, because it may be
# inconsistent with the installation you are using.

OCAML_LIB	= $(CAMLLIB)

#*************************************************************#
# A bunch of configuration macros to support both Nt and Unix

EXE	=
OBJS	= .o
ARCS	= .a
OBJ	= -$(PLATFORM)$(OBJS)
ARC	= -$(PLATFORM)$(ARCS)
NTPLAT	=
CP	= cp
MV	= mv
CHMOD	= chmod
LN	= ln
TOUCH	= touch
RM	= rm -f
#MAKE	= make			# set by default
NT	=			# unset for Unix
MKLIB   = ar cr 		# comment forces spaces
MKLIBO  =
RANLIB  = ranlib
SUBMAKE = ; $(MAKE) -k
DEPEND  = .depend
PARTIALLD = ld -r
PARTIALLDO = -o
ECHO	= echo
#*************************************************************#
BYTEPLAT =			# not need for Unix
#*************************************************************#
NTRULE	= -unix
UNIXRULE =
#*************************************************************#
# How to link various Ocaml libraries.  Should not require
# modification.
LIBCUNIX	= -lunix
LIBMLUNIX	= unix$(CMAS)
LIBCSOCK	= $(ENSLIB)/libsock$(ARC)
LIBMLSOCK	= $(ENSLIB)/socket$(CMA)
LIBCTHREADS	= -lthreads
LIBMLTHREADS	= threads$(CMAS)
LIBCSTR		= -lstr
LIBMLSTR	= str$(CMAS)
LIBMLSTRBC	= str.cma
LIBDYNLINK	= dynlink$(CMAS)
LIBTK		= tklib$(CMAS) $(TKLIBS)
#*************************************************************#
# Select whether or not to use Ocaml threads.  Ocaml threads
# only work with bytecode interpreter.  Default is no
# threads.  COMP_THR is the option needed for the
# compilation step.  LINK_THR is the option needed for the
# link step.  To use threads, you need to recompile Ensemble
# from scratch in the def directory (run make clean ; make
# depend ; make).

# No threads
COMP_THR	= # no threads
LINK_THR	= # no threads

# Use threads
#COMP_THR	= -thread
#LINK_THR	= -thread $(LIBTHREADS)

#*************************************************************#
# Root of the Ensemble distribution.  Used to find source files
# when dynamic linking

ENSROOT_ABS	= /usr/u/hayden/ensemble

#*************************************************************#
# LIBNTUNIX points to the directory of the Nt Unix library.
# This is used for cross-compiling bytecode to work with the
# Nt Unix interface.

LIBNTUNIX	= /usr/local/src/plg/ocaml-1.05/otherlibs/win32unix

#*************************************************************#
# Use IPM_BASE if your header files for IP multicast are not
# in your normal C include path.

# for Cornell CS Dept
IPM_BASE	= -I/usr/u/atm/sys-4.1.3U1.all3

# Use this "definition" if you don't have IP multicast or
# aren't sure where it is.
#IPM_BASE       =

#*************************************************************#
# Where to find ATM/UNET header files and libraries.  By
# default, these are compiled with the distribution, so you
# shouldn't need to adjust these.

# for Cornell CS Dept
LIBUNET		= /usr/u/sww/sun4/lib/libunet-2$(ARCS)
INCUNET		= -I/usr/u/sww/linux/include/unet-2

#*************************************************************#
# Where to find the Crypto stuff

CRYPTO_ROOT = /usr/u/hayden/lib/$(PLATFORM)

CRYPTO_INC = -I $(CRYPTO_ROOT)

CRYPTO_LINK = \
	$(ENSROOT)/lib/crypto$(CMA)		\
	-cclib $(ENSROOT)/lib/libcryptoc$(ARC)	\
	-cclib $(CRYPTO_ROOT)/rsaref$(ARCS)

#*************************************************************#
# Configuration infromation for threads and the C interfaces.

# SPARC-SOLARIS
HOT_CFLAGS_sparc-solaris = # empty
HOT_MLLINK_sparc-solaris = # empty
#HOT_LINK_sparc-solaris	= -lpthread -ltermcap -lsocket -lnsl -lm
HOT_LINK_sparc-solaris	= -lthread -lposix4 -ltermcap -lsocket -lnsl -lm
HOT_THREAD_OBJ_sparc-solaris = solaris_thread$(OBJ)

# I386-SOLARIS: same as for sparc-solaris
HOT_CFLAGS_i386-solaris = $(HOT_CFLAGS_sparc-solaris)
HOT_MLLINK_i386-solaris = $(HOT_MLLINK_sparc-solaris)
HOT_LINK_i386-solaris	= $(HOT_LINK_sparc-solaris)
HOT_THREAD_OBJ_i386-solaris = $(HOT_THREAD_OBJ_sparc-solaris)

# SPARC-SUNOS4
#GTHREADS_sparc-sunos4	= /usr/local/lib
GTHREADS_sparc-sunos4	= /usr/u/hayden/lib/$(PLATFORM)
HOT_CFLAGS_sparc-sunos4 = -I $(GTHREADS)
HOT_MLLINK_sparc-sunos4 = -ccopt -L$(GTHREADS) -cclib -lgthreads -cclib -lmalloc
HOT_LINK_sparc-sunos4	= -L$(GTHREADS) -lgthreads -lmalloc -ltermcap -lm
HOT_THREAD_OBJ_sparc-sunos4 = pthread_intf$(OBJ)

# I386-LINUX
HOT_CFLAGS_i386-linux	= # empty
HOT_MLLINK_i386-linux	= # empty
HOT_LINK_i386-linux	= -lgthreads -lmalloc -ltermcap -lm
HOT_THREAD_OBJ_i386-linux = pthread_intf$(OBJ)

# NT
HOT_CFLAGS_nt	= # not supported
HOT_MLLINK_nt	= # not supported
HOT_LINK_nt	= # not supported
HOT_LINK_nt	= # not supported

# ALPHA-OSF1
HOT_CFLAGS_alpha-OSF1	= -DOSF1_THREADS
HOT_MLLINK_alpha-OSF1	=
HOT_LINK_alpha-OSF1	= -lrt -lpthreads -lmach -lexc -lc_r -lm -ltermcap -taso
HOT_THREAD_OBJ_alpha-OSF1 = pthread_intf$(OBJ)

# RS6000-AIX
HOT_CFLAGS_rs6000-aix	= -DOSF1_THREADS
HOT_MLLINK_rs6000-aix	= # empty
HOT_LINK_rs6000-aix	= -lpthreads -lm -ltermcap
HOT_THREAD_OBJ_rs6000-aix = pthread_intf$(OBJ)

GTHREADS	= $(GTHREADS_$(PLATFORM))
HOT_CFLAGS	= $(HOT_CFLAGS_$(PLATFORM))
HOT_MLLINK	= $(HOT_MLLINK_$(PLATFORM))
HOT_LINK	= $(HOT_LINK_$(PLATFORM))
HOT_THREAD_OBJ	= $(HOT_THREAD_OBJ_$(PLATFORM))

#*************************************************************#
