/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
#include <iostream.h>
#include "Maestro.h"

#ifndef _WIN32
#include <sys/types.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#endif

#ifdef USE_PURIFY
#include "purify.h"
#endif

extern "C" {
#ifndef _WIN32
  void srand(int);
#endif
  int rand();
}

class  Mbr: public Maestro_GroupMember {
public:

  Mbr(int id, Maestro_GrpMemb_Options &ops) : Maestro_GroupMember(ops) {
    ID = id;
    cnt = 0;
    state = BOGUS;
    join();
  }

  int id() { return ID; }

protected:

  void grpMemb_ReceiveCast_Callback(Maestro_EndpID &origin,
				    Maestro_Message &msg) {
    int src;
    msg >> src;

    // cout << ID << " (" << me << "): CAST from " << src << " (" << origin
    // << ")" << endl;

    if (me == origin) {
      cout << ID << ": CAST from " << src << endl;
      cout << "me: " << me << "; origin: " << origin << endl;
      error->panic("Mbr:  got a CAST from myself");
    }

    // cout << ID << ": CAST from " << src << endl;
  }

  void grpMemb_ReceiveSend_Callback(Maestro_EndpID &origin,
				    Maestro_Message &msg) {
    int src;
    msg >> src;
    // cout << ID << ": SEND from " << src << endl;

    if (me == origin) {
      cout << ID << ": CAST from " << src << endl;
      cout << "me: " << me << "; origin: " << origin << endl;
      error->panic("Mbr:  got a SEND from myself");
    }
  }

  void grpMemb_AcceptedView_Callback(Maestro_GrpMemb_ViewData &viewData,
				 Maestro_Message &msg) {
    if (state != LEAVING)
      state = NORMAL;

    me = viewData.myEndpID;
    view = viewData.members;
    my_rank = viewData.myRank;

    Maestro_String vm;
    msg >> vm;

    cout << ID << ": ACCEPTED VIEW " << viewData.viewID 
	 << "(" << viewData.nmembers << " members)" << endl;

#ifdef noisy
    if (my_rank == 0) {
	// cout << ID << ": members: " << endl << viewData.members;
	cout << ID << ": nmembers = " << viewData.nmembers << endl;
	cout << ID << ": view message: \"" << vm << "\""<< endl;
	//cout << ID << ": view message size = " << msg.size() << endl;
	
	cout << ID << ": version = \"" << viewData.version << "\"" << endl;
	cout << ID << ": protocol = \"" << viewData.protocol << "\"" << endl;
	cout << ID << ": params = \"" << viewData.params << "\"" << endl;
	cout << ID << ": group daemon " << 
	    (viewData.groupdFlag ? "is in use" : "is not in use") << endl;
	cout << ID << ": view is " << 
	    (viewData.primaryFlag ? "primary" : "not primary") << endl;
    }
#endif
  }

  void grpMemb_ViewMsg_Callback(Maestro_GrpMemb_ViewData &viewData,
				/*OUT*/ Maestro_Message &viewMsg) {
    cout << ID << ": VIEW_MSG" << endl;
    Maestro_String vm("hello world");
    viewMsg << vm;
  }
  
  void grpMemb_Block_Callback() {
    state = BLOCKED;
    // cout << ID << ": BLOCK" << endl;
  }
  
  void grpMemb_Heartbeat_Callback(unsigned time) { 
    // cout << ID << ": HEARTBEAT" << endl;
    int i;
    
    if (++cnt > 100) {
      cnt = 0;

#ifdef USE_PURIFY
      cout << "\n************** Reporting Memory Leaks ****************\n";
      purify_new_leaks();
#endif
    }

    cout << "."; cout.flush();

    if (state == NORMAL) {
   
#ifdef send_msgs
	for (i = 0; i < rand() % 5; i++) {
	//cout << ID << ": sending cast" << endl;
	Maestro_Message msg;
	msg << ID;
	cast(msg);
      }
      
      if (view.size() > 1) {
	for (i = 0; i < rand() % 5; i++) {
	  //cout << ID << ": sending p2p" << endl;
	  Maestro_Message msg;
	  msg << ID;
	  send(view[(my_rank + 1) % view.size()], msg);
	}
      }
#endif

#ifdef protocol_switching
	if (view.size() == 10 && my_rank == 0 && random() % 5 == 0) {
	    cout  << "******* " << ID << " CHANGING PROPERTIES ********" << endl;
	    Maestro_String props("Gmp:Sync:Heal:Switch:Suspect:Frag");
	    changeProperties(props);
	}
#endif

#define rejoin
#ifdef rejoin
      if (view.size() > 6 && rand() % 5 == 0) {
	cout << "******* " << ID << " LEAVING ********" << endl;
	state = LEAVING;
	leave();
      }      
#endif
    }
  }

  void grpMemb_Exit_Callback() {
    cout << "******* " << ID << " RE-JOINING *******" << endl;
    state = BOGUS;
    join();
  }

private:

  int ID, my_rank;
  Maestro_EndpList view;
  Maestro_EndpID me;
  
  enum { BOGUS, NORMAL, BLOCKED, LEAVING } state;
  int cnt;
};

void main(int argc, char *argv[]) {
  Mbr *m0, *m1, *m2;
  Mbr *mbr[10];
  int id = 0;

#ifndef _WIN32
  srand(time(NULL));
#endif _WIN32

  Maestro_GrpMemb_Options ops;
  ops.heartbeatRate = 1000;

  ops.groupName = "maesto_test";
  // ops.protocol = "Top:Heal:Switch:Leave:Inter:Intra:Elect:Merge:Sync:Suspect:Top_appl:Pt2pt:Frag:Stable:Mnak:Bottom";
  ops.transports = "UDP";
  ops.argv = argv;
  ops.properties = "Gmp:Sync:Heal:Switch:Frag:Suspect:Flow";
  ops.params = "suspect_max_idle=3:int;suspect_sweep=1.000:time";
  ops.threadMode = MAESTRO_MODE_SINGLE_THREADED;
  ops.viewMsgFlag = 1;
  ops.groupdFlag = 0;

  for(id = 0; id < 10; id++)
      mbr[id] = new Mbr(id, ops);
  
  // m0 = new Mbr(/*rand() % 100*/ 1, ops);
  // m1 = new Mbr(/*rand() % 100*/ 2, ops);
  // m2 = new Mbr(/*rand() % 100*/ 3, ops);

  cout << "STARTING ENSEMBLE" << endl;
  Maestro_CSX::start(argv);
  assert(0);

#ifdef unused
  while (1) {
    sleep(1);
    if (rand() % 20 == 0) {
      cout << "*** " << m0->id() << " is LEAVING" << endl;
      delete m0;
      m0 = new Mbr(/* id++ */rand() % 100, ops);
    }
    
    if (rand() % 20 == 0) {
      cout << "*** " << m1->id() << " is LEAVING" << endl;
      delete m1;
      m1 = new Mbr(rand() % 100, ops);
    }
    
  }

  Maestro_Semaphore sema;
  sema.dec();
#endif
}
