/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
// $Header: /usr/u/hayden/cvs/ensemble/maestro/Maestro_GroupMember.h,v 1.7 1997/05/25 15:41:12 hayden Exp $

#ifndef __MAESTRO_GROUP_MEMBER_H__
#define __MAESTRO_GROUP_MEMBER_H__

/********************************************************************
 *                                                                  *
 * Author:  Alexey Vaysburd  December 96                            *
 *                                                                  *
 * Contents:  Definition of the Maestro_GroupMember class           *
 *                                                                  *
 ********************************************************************/


#include "Maestro_Types.h"

#define MAESTRO_MESSAGE_MAGIC_VID 929834

class Maestro_ViewID : virtual public Maestro_Base {
public:
    Maestro_ViewID();
    Maestro_ViewID(hot_view_id &view_id);
    inline Maestro_ViewID& operator= (Maestro_ViewID &vid2);
    inline Maestro_ViewID& operator= (hot_view_id &view_id);
    inline int operator== (Maestro_ViewID &vid2);
    inline int operator!= (Maestro_ViewID &vid2);
    inline int operator< (Maestro_ViewID &vid2);
    inline int operator> (Maestro_ViewID &vid2);
    inline void operator<< (Maestro_Message& msg);
    inline void operator>> (Maestro_Message& msg);
    inline void operator>> (ostream& out) const;
    int messageMagic() const { return MAESTRO_MESSAGE_MAGIC_VID; }
protected:
    hot_view_id vid;
};

struct Maestro_GrpMemb_ViewData {
    inline Maestro_GrpMemb_ViewData();
    Maestro_String version;
    Maestro_String groupName;
    Maestro_EndpID myEndpID;
    Maestro_EndpList members, newMembers, departedMembers;
    int nmembers, myRank, myOldRank;
    Maestro_EndpID coordinator, oldCoordinator;
    Maestro_String protocol;
    int groupdFlag;  
    Maestro_ViewID viewID;
    Maestro_String params;
    int primaryFlag;
    void dump(char *title);
};

typedef enum {
    MAESTRO_MODE_SINGLE_THREADED,
    MAESTRO_MODE_MULTI_THREADED
} Maestro_ThreadMode;

class Maestro_GrpMemb_Options : Maestro_Options {
public:
    
    Maestro_GrpMemb_Options() { reset(); }
    unsigned heartbeatRate;
    Maestro_String groupName;      
    Maestro_String protocol;
    Maestro_String properties;
    Maestro_String params;
    Maestro_String transports;
    Maestro_ErrorHandler *errorHandler;
    Maestro_ThreadMode threadMode;
    int groupdFlag;
    int viewMsgFlag;
    char **argv;
    void dump(char *title);

private:
    
    void reset() {
	heartbeatRate = MAESTRO_DEFAULT_HEARTBEAT_RATE; 

	Maestro_String props_str((char*) MAESTRO_DEFAULT_PROTOCOL_PROPERTIES);
	properties = props_str;

	Maestro_String grpnam_str("Maestro-default-group");
	groupName = grpnam_str;
	
	Maestro_String transp_str((char*) MAESTRO_DEFAULT_TRANSPORTS);
	transports = transp_str;
	
	errorHandler = 0;
	
	threadMode = MAESTRO_MODE_MULTI_THREADED;
	groupdFlag = 0;
	viewMsgFlag = 1;
	argv = 0;
    }
};

enum Maestro_GrpMemb_MsgType {
    MAESTRO_GRPMBR_MSG_TYPE_DATA,
    MAESTRO_GRPMBR_MSG_TYPE_VIEW
};

struct Maestro_GrpMemb_MsgOptions : Maestro_Options {
    // no options at present
};

// The view in which the message will be delivered.
// This type mirrors the corresp. type in hot_ens.h.
enum Maestro_MsgSendView {
    MAESTRO_MSG_SEND_UNSPECIFIED_VIEW,
    MAESTRO_MSG_SEND_CURRENT_VIEW,
    MAESTRO_MSG_SEND_NEXT_VIEW
};

class Maestro_GroupMember : virtual public Maestro_Base {
public:
    
    // Initialize the group-member object.
    inline Maestro_GroupMember(Maestro_GrpMemb_Options &membOps);
    
    Maestro_GroupMember(Maestro_GroupMember& hgm);
    inline virtual ~Maestro_GroupMember();
    virtual Maestro_GroupMember& operator= (Maestro_GroupMember& hgm);
    
    // Join the group.
    inline virtual void join();
    
    // Send point-to-point message.
    inline virtual void send(Maestro_EndpID &dest, Maestro_Message &msg);
    
    inline virtual void send(Maestro_EndpID &dest, Maestro_Message &msg,
			     Maestro_MsgSendView &sendView);
    
    inline virtual void send(Maestro_EndpID &dest, Maestro_Message &msg, 
			     Maestro_MsgSendView &sendView,
			     Maestro_GrpMemb_MsgOptions &msgOps);
    
    // Send multicast message.
    inline virtual void cast(Maestro_Message &msg);
    
    inline virtual void cast(Maestro_Message &msg, 
			     Maestro_MsgSendView &sendView);
    
    inline virtual void cast(Maestro_Message &msg, 
			     Maestro_MsgSendView &sendView, 
			     Maestro_GrpMemb_MsgOptions &msgOps);
    
    // Report group members as failure-suspected.
    inline virtual void suspect(Maestro_EndpList &suspects);
    
    // Request a change of group protocol.
    inline virtual void changeProtocol(Maestro_String &protocol);

    // Request a change of group protocol (specify properties).
    inline virtual void changeProperties(Maestro_String &properties);
    
    // Request a new view to be installed.
    inline virtual void requestNewView();
    
    // Get endpoint ID of this group member.
    inline virtual void myEndpID(Maestro_EndpID &eid);
    
    // Leave the group.
    inline virtual void leave();
    
    // Start the group communication system underneath
    // (for single-threaded mode only).
    static void start(char **argv);

    void dump(char *title);

protected:
    
    /*********************** Interface Callbacks *****************************/
    
    // Message callbacks:

    inline virtual void 
    grpMemb_ReceiveCast_Callback(Maestro_EndpID &origin,
				 Maestro_Message &msg) {}
    
    inline virtual void 
    grpMemb_ReceiveSend_Callback(Maestro_EndpID &origin,
				 Maestro_Message &msg) {}
    
    // View callbacks:
    
    inline virtual void
    grpMemb_ViewMsg_Callback(Maestro_GrpMemb_ViewData &viewData,
			     Maestro_Message &msg) {}

    inline virtual void 
    grpMemb_AcceptedView_Callback(Maestro_GrpMemb_ViewData &viewData,
				  Maestro_Message &msg) {}

    // The group is blocked for a view change:
    
    inline virtual void
    grpMemb_Block_Callback() {}
    
    // The member has left the group:
    
    inline virtual void 
    grpMemb_Exit_Callback() {}
    
    // Heartbeat:
    
    inline virtual void
    grpMemb_Heartbeat_Callback(unsigned time) {}
    
    
    /**********************************************************************/
    
private:
    
    /*********************************************************************/
    
    enum { GRPMEMB_BOGUS, 
	   GRPMEMB_JOINING, 
	   GRPMEMB_NORMAL, 
	   GRPMEMB_LEAVING 
    } mbrState;  

    int expectingViewMsg;
    Maestro_ViewID lastViewID;
    Maestro_EndpID lastViewMsgOrigin;

    Maestro_GrpMemb_Options jops;
    Maestro_GrpMemb_ViewData myView;
    hot_gctx_t gctx;
    
    // Setup a view state.
    inline void setupViewState(hot_view_state_t *view_state, 
			       /*OUT*/ Maestro_GrpMemb_ViewData &viewData);
    
    /********************* Callback dispatchers ****************************/
    
    // Received a multicast message.
    inline static void receiveCast_Dispatcher(hot_gctx_t gctx, void *env, 
					      hot_endpt_t *origin, hot_msg_t msg);
    
    // Received a point-to-point message.
    inline static void receiveSend_Dispatcher(hot_gctx_t gctx, void *env, 
					      hot_endpt_t *origin, hot_msg_t msg);
    
    // Accepted a new view.
    inline static void acceptedView_Dispatcher(hot_gctx_t gctx, void *env, 
					       hot_view_state_t *view_state);
    
    // Got a heartbeat event (invoked periodically).
    // Current time (in milliseconds) is specified.
    inline static void heartbeat_Dispatcher(hot_gctx_t gctx, void *env, 
					    unsigned rate);
    
    // The group is blocked for a view change.
    inline static void 
    Maestro_GroupMember::block_Dispatcher(hot_gctx_t gctx, void *env);
    
    // The member has left the group.
    inline static void 
    Maestro_GroupMember::exit_Dispatcher(hot_gctx_t gctx, void *env);
};

#endif // __MAESTRO_GROUP_MEMBER_H__
