(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SYNC.ML : view synchronization protocol *)
(* Author: Mark Hayden, 12/95 *)
(* Manages group synchronization during view changes. *)
(**************************************************************)
(* BUG: the comments in this file are out of date *)
(**************************************************************)
(* TODO:

 * change computation of coord.

 *)
(**************************************************************)
open Util
open Event
open Layer
open Trans
open View
open Arrayop
(**************************************************************)
let name = Trace.source_file "SYNC"
(**************************************************************)

type header =
  | Block
  | BlockOk of bool array

type state = {
  failed	          : bool array ;
  mutable gossip          : rank array ;
  mutable coord           : rank ;	(* who do I think is coord? hack *)
  mutable dn_block        : bool ;	(* have I passed down a EBlock? *)
  mutable req_up_block_ok : bool ;	(* have I got a EBlock from above? *)
  mutable up_block_ok     : bool ;	(* have I passed up an EBlockOk? *)
  block_ok	          : bool array
}

(**************************************************************)

let dump (ls,vs) s =
  eprintf "SYNC:dump:%s\n" ls.name ;
  eprintf "  req_up_block_ok=%b rank=%d\n" s.req_up_block_ok ls.rank ;
  eprintf "  dn_block=%b up_block_ok=%b\n" s.dn_block s.up_block_ok ;
  eprintf "  failed  =%s\n" (string_of_bool_array s.failed) ;
  eprintf "  block_ok=%s\n" (string_of_bool_array s.block_ok)

(**************************************************************)

let init () (ls,vs) =
  let failed = array_create name ls.nmembers false in {
  req_up_block_ok = false ;
  coord         = 0 ;
  failed        = failed ;
  gossip        = gossip failed ls.rank ;
  dn_block    	= false ;
  up_block_ok	= false ;
  block_ok    	= array_create name ls.nmembers false
}

(**************************************************************)

let hdlrs s (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let failwith m = dump (ls,vs) s ; failwith (name^":"^m) in
  let assert a s = if not a then failwith s in
  let ack = make_acker name dnnm in
  let log = Trace.log name ls.name in

  let do_gossip () =
    let hdr = BlockOk(Array.copy s.block_ok) in
    if ls.rank > s.coord then
      dnlm (sendRank name s.coord) hdr
(*
    dnlm (castEv name) hdr
*)
  in

  let check_ok () =
    if s.req_up_block_ok 
    && not s.up_block_ok
    && array_for_all2 (||) s.block_ok s.failed
    then (
      log (fun () -> sprintf "EBlockOk") ;
      s.up_block_ok <- true ;
      upnm (create name EBlockOk[]) ;
    )
  in

  let up_hdlr ev abv () = up ev abv

  and uplm_hdlr ev hdr = match getType ev,hdr with

  (* Block: cast from coordinator. 
   *)
  | (ECast|ESend), Block ->
      if not s.dn_block then (
	s.dn_block <- true ;
	dnnm (create name EBlock[])
      ) ;
      ack ev ; free name ev

  (* BlockOk: Got block Ok from other members, mark him
   * as OK and check whether we're done blocking.
   *)
  | (ECast|ESend), BlockOk(block_ok) ->
      mergify s.block_ok block_ok ;
      check_ok () ;
      ack ev ; free name ev

  | _ -> failwith "bad up event"

  and upnm_hdlr ev = match getType ev with

  (* EFail: Mark some members as being failed.  Check if
   * we're done blocking.
   *)
  | EFail ->
      let failed = getFailures ev in
      List.iter (fun rank ->
        s.failed.(rank) <- true
      ) failed ;

      (* Hack!  Recompute the rank of the coordinator. 
       *)
      for i = pred ls.nmembers downto 0 do
	if not s.failed.(i) then
      	  s.coord <- i
      done ;
      s.gossip <- gossip s.failed ls.rank ;
      do_gossip () ;
      upnm ev ;
      check_ok ()

  (* EBlockOk: Collect EBlockOk's.
   *)
  | EBlockOk -> 
      s.block_ok.(ls.rank) <- true ;
      do_gossip () ;
      check_ok () ;
      free name ev ;

  | EDump -> ( dump (ls,vs) s ; upnm ev )
  | _ -> upnm ev

  and dn_hdlr ev abv = dn ev abv ()

  and dnnm_hdlr ev = match getType ev with

  (* Layer above has started blocking group.  If blocking
   * is already done then deliver EBlockOk.  
   *)
  | EBlock ->
      assert (not s.req_up_block_ok) "2nd EBlock" ;
      s.req_up_block_ok <- true ;
      if not s.dn_block then (
	log (fun () -> "Block") ;
        s.dn_block <- true ;
	dnlm (create name ECast[NoTotal]) Block ;
        dnnm ev
      ) else (
      	free name ev
      )

  | _ -> dnnm ev

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
