(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SLANDER.ML *)
(* Author: Zhen Xiao, Mark Hayden, 02/97 *)
(**************************************************************)
open Trans
open Util
open Layer
open Event
open View
(**************************************************************)
let name = Trace.source_file "SLANDER"
(**************************************************************)

type header = Slander of rank list

type state = {
  mutable suspects : rank list
}

let dump (ls,vs) s =
  eprintf "SLANDER:dump:%s\n" ls.name ;
  eprintf "  suspects=%s\n" (string_of_int_list s.suspects)

let init () (ls,vs) = {
  suspects = []
}

let hdlrs s (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let failwith m = dump (ls,vs) s ; failwith (name^":"^m) in
  let ack = make_acker name dnnm in
  let log = Trace.log name ls.name in

  let up_hdlr ev abv () = up ev abv

  and uplm_hdlr ev hdr = match getType ev,hdr with
  | (ECast|ESend), Slander(suspects) ->
      let origin = getOrigin ev in
      log (fun () -> sprintf "got Slander(%s) from %d" 
        (string_of_int_list suspects) origin) ;

      if List.mem ls.rank suspects then (
	if not (List.mem origin s.suspects) then (
          s.suspects <- Lset.union s.suspects [origin] ;
          dnnm (suspectReason name s.suspects name) ;
          dnlm (castEv name) (Slander s.suspects)
	)
      ) else (
        if not (Lset.super s.suspects suspects) then (
          s.suspects <- Lset.union s.suspects suspects ;
          dnnm (suspectReason name s.suspects name) ;
        )
      ) ;
      ack ev ; free name ev
  | _ -> failwith "unknown local message"
   
  and upnm_hdlr ev  = match getType ev  with
  | ESuspect ->
      let suspicions = getSuspects ev in
      if not (Lset.super s.suspects suspicions) then (
        s.suspects <- Lset.union s.suspects suspicions;  
        dnlm (castEv name) (Slander s.suspects);
      ) ;
      upnm ev

  | EDump -> ( dump (ls,vs) s ; upnm ev )
  | _ -> upnm ev

  and dn_hdlr ev abv = dn ev abv ()

  and dnnm_hdlr = dnnm

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
