(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(*
 *  TransisE, (Version 0)
 *  Hebrew University
 *  Copyright Notice
 *
 *  The contents of this file are subject to copyright by
 *  the Hebrew University, which reserves all rights.  Use,
 *  distribution and copying of this material is expressly
 *  prohibited except by prior written permission from
 *  the Hebrew University or from its appropriately authorized 
 *  agents and licensors.
 *)
(**************************************************************)
(**************************************************************)
(* SMQ.ML : Simple variable length queue implementation *)
(* Author: Ohad Rodeh, 12/96 *)
(* Based on code by: Mark Hayden - from iq.ml.*)
(**************************************************************)
(* 
               	  head        read   	tail
                   \/          \/        \/
  1: [][][][][][][][][][][][][][][][][][][][][][][][][]
     0<--- reset->                       <---- unset ...
*)
open Printf
(**************************************************************)
type 'a opt = 
  | Full of 'a
  | Unset					
  | Reset					

type 'a t = {
  mutable head   : int ;
  mutable tail 	 : int ;
  mutable read	 : int ;

  mutable offset : int ;
  mutable max	 : int ;
  mutable array  : 'a opt array
}

(**************************************************************)
val nth          : 'a t -> int -> 'a option
(* [nth iq seq], returns the cell at sequence number [seq], of queue
   [iq].
*)

val nth_set      : 'a t -> int -> 'a -> bool
(* [nth_set iq seq val], sets the cell at sequence number [seq], of
   queue [iq], to [val].
*)

val clear        : 'a t -> int -> unit
(* [clear iq seq] Clears queue [iq], from sequence number [seq] down. 
   *)

val advance_tail : 'a t -> int -> unit
(* [advance_tail iq t] advances [iq]'s tail by a delta of [t].
   *)

val empty        : unit -> 'a t 
(* Returns an empty intialized queue.
   *)

val read_hole    : 'a t ->  (int * int) option 
(* [read_hole iq ] Returns the hole closest to the [read] sequence number. 
   *)

val list_of_smq_interval : (int * int) -> 'a t -> ('a -> 'b option) 
  -> (int * 'b) list
(* [list_of_smq_interval (lo,hi) iq f], returns the list of non-empty
   queue elements, betweem seqence numbers [lo] to [hi]. It applys
   function f to them, and returns with each element, its sequence
   number.
   *)



