(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SUB.ML *)
(* Author: Mark Hayden, 4/95 *)
(* Sends pt2pt messages as casts *)
(**************************************************************)
open Layer
open View
open Event
open Trans
(**************************************************************)
let name = Trace.source_file "SUBCAST"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type header = NoHdr | Send of rank list

let init () (ls,vs) = ()

let hdlrs () (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let ack = make_acker name dnnm in
  let up_hdlr ev abv hdr = match getType ev, hdr with
  | ECast, Send(dests) ->
      if List.mem ls.rank dests then (
        up (set name ev [Type ESend; Ack NoAck]) abv
      ) else (
      	free name ev
      ) ;
      ack ev

  | _, NoHdr -> up ev abv
  | _, _     -> failwith "bad up event"

  and uplm_hdlr ev hdr = failwith "bad uplm event"
  and upnm_hdlr = upnm

  and dn_hdlr ev abv = match getType ev with
  | ESend ->
      if not (getUnreliable ev) then (
	let ranks = getRanks ev in
	let ev = set name ev [Type ECast;Ranks []] in
      	dn ev abv (Send(ranks))
      ) else (
      	dn ev abv NoHdr
      )

  | _ -> dn ev abv NoHdr

  and dnnm_hdlr = dnnm

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
