(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* LOCAL.ML *)
(* Author: Mark Hayden, 6/95 *)
(**************************************************************)
open Layer
open View
open Event
open Util
(**************************************************************)
let name = Trace.source_file "LOCAL"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type header = NoHdr

let init () (ls,vs) = ()

let hdlrs () (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let up_hdlr ev abv hdr = up ev abv
  and uplm_hdlr ev hdr = failwith "uplm_hdlr"
  and upnm_hdlr = upnm

  and dn_hdlr ev abv = match getType ev with
  | ECast ->
      up (create name ECast[Origin ls.rank; Iov (getIov ev)]) abv ;
      dn ev abv NoHdr

  | ESend ->
      if List.mem ls.rank (getRanks ev) then (
      	up (create name ESend[Origin ls.rank; Iov (getIov ev)]) abv ;
	if List.length (getRanks ev) = 1 then
  	  free name ev
	else
	  dn (set name ev[Ranks (except ls.rank (getRanks ev))]) abv NoHdr
      ) else (
	dn ev abv NoHdr
      )

  | _ -> dn ev abv NoHdr

  and dnnm_hdlr = dnnm

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
