(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DROP.ML : randomly drops and delays messages at the 
 * reciever . *)
(* Author: Mark Hayden, 1/96 *)
(* Similar to Delay layer by Ohad Rodeh *)
(**************************************************************)
open Trans
open Layer
open View
open Event
open Util
(**************************************************************)
let name = Trace.source_file "DROP"
(**************************************************************)

type 'abv item =
  | Up of Event.up * 'abv
  | Upnm of Event.up

type 'abv state = {
    alarm : Alarm.t ;
    buf : (Time.t, 'abv item) Priq.t ;
    mutable acct_delivered : int ;
    mutable acct_dropped : int ;
    mutable sleeping : bool
}

(**************************************************************)

let dump (ls,vs) s = ()

(**************************************************************)

let init () (ls,vs) = { 
  buf = Priq.create (*(>=)*) Time.zero ;
  acct_dropped = 0 ;
  acct_delivered = 0 ;
  sleeping = false ;
  alarm = Alarm.get ()			(* Hack! *)
}

(**************************************************************)

let hdlrs s (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let failwith m = dump (ls,vs) s ; failwith (name^":"^m) in
  let log = Trace.log name ls.name in

  let distrib =
    let drop_rate = Param.float vs.params "drop_rate" in
    let drop_delay = Param.time vs.params "drop_delay" in
    let drop_delay = 2.0 *. (Time.to_float drop_delay) in
    fun () ->
      let p = Random.float 1.0 in
      if p < drop_rate then (
	s.acct_dropped <- succ s.acct_dropped ;
	None
      ) else (
	let delay = p *. drop_delay in
	let delay = Time.of_float delay in
	Some(delay)
      )
  in

  let up_hdlr ev abv () = match getType ev with
  | (ECast|ESend) ->
      if s.sleeping then (
	free name ev
      ) else (
	match distrib () with
	| None ->
	    free name ev
	| Some delay ->
	    (* Deliver after a certain delay....
	     *)
	    if delay <= Time.zero then (
	      up ev abv
	    ) else (
	      let time = Alarm.gettime s.alarm in
	      let deliver = Time.add time delay in
	      Priq.add s.buf deliver (Up(ev,abv)) ;
	      dnnm (timerAlarm name deliver)
	    )
      )
  | _ -> up ev abv 

  and uplm_hdlr ev () = failwith "unknown local message"

  and upnm_hdlr ev = match getType ev with
  | ETimer ->
      let time = getTime ev in
      Priq.get s.buf (fun _ e ->
	s.acct_delivered <- succ s.acct_delivered ;
	match e with
	| Up(ev,abv) -> 
	    if s.sleeping then free name ev else up ev abv
	| Upnm(ev) -> 
	    if s.sleeping then free name ev else upnm ev
      ) time ;
      upnm ev

  | EExit ->
      Priq.clear s.buf (fun _ it ->
	match it with
	| Up(ev,_) -> free name ev
	| Upnm ev -> free name ev
      ) ;
      upnm ev

  | EAccount ->
      log (fun () -> sprintf "delivered=%d dropped=%d" s.acct_delivered s.acct_dropped) ;
      upnm ev

  | EDump -> ( dump (ls,vs) s ; upnm ev ) 
  | _ -> upnm ev

  and dn_hdlr ev abv = dn ev abv ()
  and dnnm_hdlr = dnnm

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vs = Layer.hdr_state init hdlrs None NoOpt args vs

let _ = 
  Param.default "drop_rate" (Param.Float 0.01) ;
  Param.default "drop_delay" (Param.Time (Time.of_float 0.001)) ;
  Layer.install name (Layer.init l)

(**************************************************************)
