(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* CHK_TOTAL.ML *)
(* Author: Mark Hayden, 10/96 *)
(* Tests that all members see broadcasts in total ordering.
 * Assumes fifo from members, too. *)
(**************************************************************)
open Trans
open Layer
open Event
open View
open Util
(**************************************************************)
let name = Trace.source_file "CHK_TOTAL"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type header = NoHdr | NoTot | Gossip of rank array

let init () (ls,vs) = ()

let hdlrs () (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let log = Trace.log name ls.name in
  let recd = Queue.create () in
  let ack = make_acker name dnnm in
  let got_view = ref false in

  let chk_ranks = ref None in
  let chk_rmt = ref [] in
  let chk_total () =
    if_some !chk_ranks (fun ranks ->
      List.iter (fun (rmt_rank,rmt_ranks) ->
	log (fun () -> sprintf "verifying:%d->%d" ls.rank rmt_rank) ;
	if rmt_ranks <> ranks then (
	  eprintf "CHK_TOTAL:ordering failure{%s}\n" ls.name ;
	  eprintf "  rank: %d rmt_rank: %d\n" ls.rank rmt_rank ;
	  eprintf "  view_id=%s\n" (View.string_of_id vs.view_id) ;
	  eprintf "     my cast:%s\n" (string_of_int_array ranks) ;
	  eprintf "    rmt cast:%s\n" (string_of_int_array rmt_ranks) ;
	  failwith "ordering failure"
	)
      ) !chk_rmt ;
      chk_rmt := []
    )
  in

  let up_hdlr ev abv hdr = match getType ev,hdr with
  | ECast,NoHdr ->
      if !got_view then
      	failwith "ECast after EView" ;
      Queue.add ((getOrigin ev)) recd ;
      up ev abv
  | ECast,NoTot ->
      up ev abv
  | _,NoHdr -> up ev abv
  | _ -> failwith "bad up event"

  and uplm_hdlr ev hdr = match getType ev,hdr with
  | ECast,Gossip(ranks)  ->
      chk_rmt := ((getOrigin ev),ranks) :: !chk_rmt ;
      chk_total () ;
      ack ev ; free name ev
  | _ -> failwith "unknown local message"

  and upnm_hdlr ev = match getType ev with
  | EView ->
      got_view := true ;
      let ranks = list_of_queue recd in
      let ranks = Array.of_list ranks in
      chk_ranks := Some ranks ;
      chk_total () ;
      if !verbose then
      	eprintf "CHK_TOTAL:sending:%s\n" (string_of_int_array ranks) ;
      dnlm (create name ECast[NoTotal]) (Gossip ranks) ;
      upnm ev
  | _ -> upnm ev
  and dn_hdlr ev abv = match getType ev with
  | ECast ->
      if not (getNoTotal ev) then (
      	if !got_view then failwith "ECast after EView" ;
      	dn ev abv NoHdr
      ) else (
      	dn ev abv NoTot
      )
  | _ -> dn ev abv NoHdr

  and dnnm_hdlr = dnnm

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
