(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* CHK_SYNC.ML *)
(* Author: Mark Hayden, 6/95 *)
(* Tests that all members saw the same number of broadcast
 * messages in each view. *)
(**************************************************************)
open Trans
open Layer
open Event
open Util
open View
(**************************************************************)
let name = Trace.source_file "CHK_SYNC"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

type header = NoHdr 
  | Appl
  | Gossip of View.id * seqno array * bool array

type state = {
  failed : bool array ;
  casts : seqno array
} 

let init () (ls,vs) = {
  failed = array_create name ls.nmembers false ;
  casts = array_create name ls.nmembers 0
}   

let hdlrs s (ls,vs) {up_out=up;upnm_out=upnm;dn_out=dn;dnlm_out=dnlm;dnnm_out=dnnm} =
  let log = Trace.log name ls.name in
  let ack = make_acker name dnnm in

  let chk_casts = ref None in
  let chk_rmt = ref [] in
  let chk_sync () =
    if_some !chk_casts (fun casts ->
      List.iter (fun (rmt_rank,rmt_casts,rmt_fail) ->
      	log (fun () -> sprintf "verifying:%d->%d" ls.rank rmt_rank) ;
	if rmt_casts <> casts then (
	  eprintf "CHK_VSYNC:virtual synchrony failure{%s}\n" ls.name ;
	  eprintf "  rank: %d rmt_rank: %d\n" ls.rank rmt_rank ;
	  eprintf "  view_id=%s\n" (View.string_of_id vs.view_id) ;
	  eprintf "   my failed:%s\n" (string_of_bool_array s.failed) ;
	  eprintf "     my cast:%s\n" (string_of_int_array casts) ;
	  eprintf "    rmt cast:%s\n" (string_of_int_array rmt_casts) ;
	  eprintf "  rmt failed:%s\n" (string_of_bool_array rmt_fail) ;
	  dnnm (create name EDump[])
	)
      ) !chk_rmt ;
      chk_rmt := []
    )
  in

  let up_hdlr ev abv hdr = match getType ev,hdr with
  | ECast, Appl ->
(*
      eprintf "CHK_SYNC:%s\n" (Event.to_string ev) ;
*)
      let origin = getOrigin ev in
      if origin <> ls.rank then
        array_incr s.casts origin ;
      up ev abv
  | _,NoHdr -> up ev abv
  | _,_ -> failwith "bad up event"

  and uplm_hdlr ev hdr = match getType ev,hdr with
  | ECast,Gossip(view_id,rmt_casts,rmt_fail) ->
      let origin = getOrigin ev in
      chk_rmt := (origin,rmt_casts,rmt_fail) :: !chk_rmt ;
      chk_sync () ;
      ack ev ; free name ev
  | _,_ -> failwith "bad uplm event"

  and upnm_hdlr ev = match getType ev with
  | EView ->
      let casts = Array.copy s.casts in
      let failed = Array.copy s.failed in
      chk_casts := Some casts ;
      chk_sync () ;
      dnlm (create name ECast[NoTotal]) 
        (Gossip(vs.view_id,casts,failed)) ;
      upnm ev

  | EFail ->
      let failed = getFailures ev in
      List.iter (fun rank ->
      	s.failed.(rank) <- true
      ) failed ;
      upnm ev
  | _ -> upnm ev

  and dn_hdlr ev abv = match getType ev with
  | ECast ->
      if getApplMsg ev then (
      	array_incr s.casts ls.rank ;
        dn ev abv Appl
      ) else (
	dn ev abv NoHdr
      )
  | _ -> dn ev abv NoHdr

  and dnnm_hdlr ev = match getType ev with
  | EBlockOk ->
      dnnm ev
  | _ -> dnnm ev

in {up_in=up_hdlr;uplm_in=uplm_hdlr;upnm_in=upnm_hdlr;dn_in=dn_hdlr;dnnm_in=dnnm_hdlr}

let l args vf = Layer.hdr init hdlrs None NoOpt args vf

let _ = Layer.install name (Layer.init l)

(**************************************************************)
