(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* TRANSPORT.MLI *)
(* Author: Mark Hayden, 7/95 *)
(**************************************************************)
open Trans
(**************************************************************)

(* This is the type of object used to send messages.
 *)
type 'msg t

(* Enable security enforcement.
 *)
val set_secure : unit -> unit

(* Construct and enable a new transport instance.
 *)
val f :
  Version.id ->				(* version id *)
  Group.id ->				(* group id *)
  Endpt.id ->				(* endpoint id *)
  Stack_id.t ->				(* stack id *)
  Proto.id ->				(* protocol id *)
  Security.key ->			(* key *)
  View.t ->				(* view *)
  Addr.set array ->			(* addresses of members *)
  View.id ->				(* view id *)
  bool ->				(* gossip tranport? *)
  'msg Route.t ->			(* connection table *)
  (Conn.kind -> rank -> 'msg) ->	(* message handler *)
  'msg t
	
(**************************************************************)

val disable	: 'msg t -> unit	(* disable the transport*)
val send	: 'msg t -> rank -> 'msg (* send on the transport *)
val cast	: 'msg t -> 'msg	(* cast on the transport *)
val gossip	: 'msg t -> 'msg	(* gossip on the transport *)
val merge	: 'msg t -> View.id option -> Endpt.full -> 'msg

(**************************************************************)
