(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* STACKE.ML *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
open Trans
open Util
open View
open Event
open Actual
(**************************************************************)
let name = Trace.source_file "STACKE"
let failwith s = failwith (Util.failmsg name s)
let log = Trace.log name ""
(**************************************************************)

(* Top-level scheduler.
 *)
let root_sched = Sched.create "root_sched"

(**************************************************************)

let init_stack state (ls,vs) up =
  let glue = Arge.get Arge.glue in
  let stack = Proto.layers_of_id vs.proto_id in
  let stack = List.map Proto.string_of_l stack in
  log (fun () -> sprintf "proto=%s" (Proto.string_of_id vs.proto_id)) ;
  log (fun () -> sprintf "stack=%s" (string_of_list ident stack)) ;
  let procure l = Glue.convert glue (Layer.procure_hide l state) in
  let stack =
    match stack with
    | [] -> failwith "init_stack:empty protocol stack"
    | hd :: tl ->
      	List.fold_left (fun stk lyr -> Glue.compose stk (procure lyr)) (procure hd) tl
  in
  let dn = Glue.init stack () Layer.NoMsg root_sched (ls,vs) up in
  dn

(**************************************************************)

let config_full interface (ls,vs) up =
  let log = Trace.log name ls.name in
  let state = Layer.new_state interface in
  let rec loop (ls,vs) dn_rr =
(*
    eprintf "STACKE:config_full:vs=%s\n" (View.string_of_state vs) ;
*)
    let next vs =
      match !dn_rr with
      | None -> failwith "2nd EView"
      | Some dn_r ->
	  (* Loop and then zap my reference to the dn_r ref.
	   *)
	  loop vs (ref (Some dn_r)) ;
      	  dn_rr := None
    in

    let up ev = match getType ev with
    | ELeave | EBlockOk | EPrompt -> up ev
    | EView ->
	let old_addr = View.addr (ls,vs) in
	let new_vs = getViewState ev in
	let new_ls = View.local name ls.endpt new_vs in 
	let new_addr = View.addr (new_ls,new_vs) in
	if new_addr = old_addr then 
    	  next (new_ls,new_vs)
	else
	  up ev
    | _ -> failwith "sanity"
    in

    let dn = init_stack state (ls,vs) up in

    let dn ev = match getType ev with
    | EFail | EBlock | EExit -> dn ev
    | EView ->
	dn (Event.create name EExit[]) ;
	let new_vs = getViewState ev in
	let new_ls = View.local name ls.endpt new_vs in 
	next (new_ls,new_vs)
    | _ -> failwith "sanity"
    in

    match !dn_rr with
    | None -> failwith "sanity"
    | Some dn_r ->
    	dn_r := dn
  in

  let dn_r = ref (fun _ -> failwith "sanity") in
  loop (ls,vs) (ref (Some dn_r)) ;
  let dn ev = !dn_r ev in
  dn

(**************************************************************)

let config interface vs =
  let up _ = () in
  let dn = config_full interface vs up in
  ()

(**************************************************************)
