(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PANEL.ML *)
(* Author: Mark Hayden, Alexey Vaysburd 4/97 *)
(**************************************************************)
open Util
(**************************************************************)

type info = string * string

let logs = Hashtbl.create 10

let get_log name =
  try Hashtbl.find logs name with Not_found ->
    let ret = ref None in
    Hashtbl.add logs name ret ;
    ret

let post e g n =
  let x = get_log (e,g,n) in
  fun info ->
    match !x with
    | Some f -> f info
    | None -> ()

let register e g n f =
  let x = get_log (e,g,n) in
  x := Some(f)

let unregister e g n =
  let x = get_log (e,g,n) in
  x := None				(* Memory leak? *)

let list_of_logs () =
  let l = list_of_hashtbl logs in
  let l = List.map fst l in
  l

(**************************************************************)

