(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* HSYSSUPP.MLI *)
(* Author: Mark Hayden, 6/96 *)
(**************************************************************)
open Trans
(**************************************************************)

(* This is an optimized function for reading from the
 * network.
 *)
val block : 
  Mbuf.t ->
  (int -> Iovec.rbuf -> ofs -> len -> unit) ->
  (Hsys.socket * Hsys.handler) list -> 
  float ->
  (unit-> bool)

(* Turns a tcp socket into a send and recv function.
 *)
val tcp : Hsys.socket -> 
  (buf -> ofs -> len -> int) * 
  (unit -> (string list)option)

(* This sends iovecs in the same manner as supported
 * by the Hsys module.
 *)
val sendvopt : Hsys.info -> Iovecl.t -> unit
