(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* GLUE.MLI *)
(* Author: Mark Hayden, 10/96 *)
(**************************************************************)

type glue = 
  | Imperative 
  | Functional
  | Threaded

type ('a,'b) t

val of_string : string -> glue

val convert : glue -> ('bel,'abv,'state) Layer.basic -> ('bel,'abv) t

val compose : ('abv,'mid) t -> ('mid,'bel) t -> ('abv,'bel) t

type ('top,'bot) init = ('top,'bot) t -> 
  'top ->
  'bot ->
  Sched.t ->
  View.full ->
  (Event.up -> unit) -> 
  (Event.dn -> unit)

(*
val init : ('top,'bot) init
*)
val init : ('top,('a,'b,'c)Layer.msg) init

(**************************************************************)

val stats : unit -> unit

(**************************************************************)
