(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DISP.ML *)
(* Author: Mark Hayden, 6/95 *)
(* Based on code by Werner Vogels *)
(**************************************************************)
open Layer
open Util
open View
open Event
(**************************************************************)

let l name (ls,vs) = ((),fun {up_lout=up;dn_lout=dn} ->
  let msg = sprintf "%s{%s}:" name (Endpt.string_of_id ls.endpt) in

  let up_hdlr ev hdr =
    if getType ev <> ETimer then (
      printf "%s%s" msg (to_string ev) ;
      up ev hdr
    )
  and dn_hdlr ev hdr =
    if getType ev <> ETimer then (
      printf "%s%s" msg (to_string ev) ;
      dn ev hdr
    )
  in {up_lin=up;dn_lin=dn})

(**************************************************************)
