(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* ASYNC.ML *)
(* Author: Mark Hayden, 7/95 *)
(**************************************************************)
let name = Trace.source_file "ASYNC"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)
open Util

(* Asynchronous request management.
 *)
let table = 
  let table = Hashtbl.create 10 in
  Trace.install_root (fun () ->
    [sprintf "ASYNC:#asyncs=%d" (hashtbl_size table)]
  ) ;
  table

let add id f =
  let fro = ref (Some f) in
  let disable () =
    fro := None ;
    try 
      match 
	!(Hashtbl.find table id) 
      with 
      |	None ->
	  (* Perhaps installed by me.
	   *)
	  Hashtbl.remove table id
      |	Some _ ->
	  (* Must have been installed by someone else.
	   *)
	  ()
    with Not_found -> ()
  in

  begin 
    try
      Hashtbl.remove table id
    with Not_found -> () 
  end ;

  Hashtbl.add table id fro ;
  disable

let find id =
  let fro = ref (ref None) in
  let rec loop () = 
    match !(!fro) with
    | None -> (
 	try 
	  fro := Hashtbl.find table id ;
	  loop ()
	with Not_found -> ()
(*
	  Hashtbl.iter (fun (g,e) _ -> eprintf "ASYNC:async:%s,%s\n"
	    (Group.string_of_id g) (Endpt.string_of_id e)) table ;
	  eprintf "ASYNC:async:key:%s,%s\n"
	    (Group.string_of_id (fst id)) (Endpt.string_of_id (snd id)) ;
*)
(*
	  eprintf "ASYNC:could not find async:warning\n"
*)
      )
    | Some f -> f ()
  in loop	  

(**************************************************************)
