/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/*
 * Contents:  Error interface for HOT
 *
 * Author:  Alexey Vaysburd, November 1996
 *
 */

#include <string.h>
#include <memory.h>
#include <malloc.h>
#include <stdio.h>

/* Obscured error type.
 */
typedef struct hot_err *hot_err_t ;

/* Normal return value
 */ 
#define HOT_OK NULL

/* Create an error object with specified code and reason
 */ 
hot_err_t hot_err_Create(unsigned err_code, char *err_string);

/* Release an error object
 */
void hot_err_Release(hot_err_t err);

/* Return the reason of an error
 */
char* hot_err_ErrString(hot_err_t err);

/* Return the code of an error
 */
unsigned hot_err_ErrCode(hot_err_t err);

/* Panic using the error message.
 */
void hot_err_Panic(hot_err_t err, char *info) ;

/*#define HOT_ERROR_DEBUG_MEMORY_LEAKS*/

#if (defined HOT_ERROR_DEBUG_MEMORY_LEAKS) && (!defined HOT_ERROR_NO_DEBUG_WRAPPERS)

char *hot_debug_mem_Malloc(unsigned size, char *file, unsigned line);
void hot_debug_mem_Free(void *ptr, char *file, unsigned line);

#define malloc(s) hot_debug_mem_Malloc((s),__FILE__,__LINE__)
#define free(p) hot_debug_mem_Free((p),__FILE__,__LINE__)

#endif
