/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
/****************************************************************************/
#include <assert.h>
#include <string.h>
#include <stdlib.h>
/****************************************************************************/
#include "hot_sys.h"
#include "hot_error.h"
#include "hot_thread.h"
#include "hot_msg.h"
#include "hot_ens.h"
#include "hot_mem.h"
/****************************************************************************/

channel_t ch_gctx = {"gctx"} ;
channel_t ch_endpt_array = {"endpt_array"} ;
channel_t ch_dncall = {"dncall"} ;
channel_t ch_joinops = {"joinops"} ;
channel_t ch_protocol = {"protocol"} ;

static channel_t *channels[100] = {
  &ch_gctx,
  &ch_endpt_array,
  &ch_dncall,
  &ch_joinops,
  &ch_protocol,
  NULL
} ;

void print_channels(void) {
  int i ;
  for (i=0;channels[i];i++) {
    fprintf(stderr,"HOT_MEM:channel:%s objects=%d bytes=%d\n",
	    channels[i]->name,
	    channels[i]->objects,
	    channels[i]->bytes) ;
  }
}

/****************************************************************************/

void *hot_malloc(
	channel_t *ch,
	unsigned size
) {
  void *mem ;
  assert(size > 0) ;

  ch->bytes += size ;
  ch->objects ++ ;

/*
  fprintf(stderr,"HOT_C:malloc:%d:%s\n",size,debug) ;
*/  
  {
    static int count = 0 ;
    count ++ ;
    if (count % 10 == 0) {
/*
      print_channels() ;
*/
    }
  }

  mem = malloc(size) ;
  if (mem == NULL) {
    char buf[100] ;
    sprintf(buf,"%s:malloc returned NULL",ch->name) ;
    hot_sys_Panic(buf) ;
  }
  memset(mem,0,size) ;
  return mem ;
}

void *hot_free(
	channel_t *ch,
	unsigned size,
	void *mem
) {
  assert(mem != NULL) ;
  assert(size > 0) ;

  ch->bytes -= size ;
  ch->objects -- ;
/*
  fprintf(stderr,"HOT_C:free:%d:%s\n",size,debug) ;
*/
  memset(mem,0,size) ;
  free(mem) ;
}

/****************************************************************************/
