(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
open Trans
(**************************************************************)

type id = int
type endpt = string
type msg = string

(*################ Types shared with the C application ######################*)
 
(* NOTE:  *Any* changes to type definitions below require corresp. 
 *        modifications to be done in the C stub.
 *)


(* These options are passed with application's join() downcalls.
 *)
type ens_join_options = {
  jops_hrtbt_rate	: float ;
  jops_transports	: string ;
  jops_protocol	        : string ;
  jops_group_name	: string ;
  jops_properties	: string ;
  jops_use_properties	: bool ;
  jops_groupd	        : bool ;
  jops_params	        : string ;
  jops_debug            : bool
}

(* Types of C application's downcalls to Ensemble *)
type dncall = 
  | C_Join of ens_join_options 
  | C_Cast of msg
  | C_Send of endpt * msg
  | C_Suspect of endpt array 
  | C_Protocol of string
  | C_Properties of string
  | C_Leave of unit
  | C_Prompt of unit
  | C_Void of unit

type c_dncall = {
  gid	: id;
  dncall : dncall 
}

(* This describes a group member ("group context").
 * The other part of group-context struct is at the C appl. side.
 *)
type gctx = {
  id	        : id ;			(* index in the gctx array *)
  dncalls	: dncall Queuee.t ;	(* pending application downcalls *)
  mutable hb_requested : bool ;
  mutable vs    : View.state ;
  mutable ls    : View.local ;
  mutable sview	: endpt array ;		(* current group view *)
  mutable exited : bool			(* set after exit event *)
}

(**************************************************************)

val add : id -> (dncall -> unit) -> unit

val get : id -> dncall -> unit

val destroy : debug -> id -> unit

val string_of_gctx : gctx -> string

(**************************************************************)
