(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* SESSION.MLI: session module *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)

type sess_sig =
| SessSigKill
| SessSigSuspend
| SessSigResume

type sess_opname =
| SeCreate
| SeWait
| SeSig
| SeGetState
| SeDestroy
| SeNone
| PrCreate
| PrWait
| PrSig
| PrGetState
| PrNone
| DBGet
| DBDelete
| DBChange
| DShut

type sessproc = {
    seprocname		: string ;
    seprogram		: string ;
    seenv		: string array ;
    seprocsvr		: Ensemble.Endpt.id 
}

type sessreq = {
    reqid		: int ;
    sessop 		: sess_opname ;
    clientrid		: Rpc.Sockio.request_id ;
    mutable ntowait	: int ;
    mutable proctoreturn: sessproc list 
}

type session = {
    sessname		: string ;
    mutable proc_ticket	: int ;
    mutable req_ticket	: int ;
    mutable processes	: sessproc list ;
    mutable requests	: sessreq list 
}

type sesslist = {
    mutable ticket : int ;
    mutable sessions : session list 
}

type command =
| Noop of unit
| Cmd of string

type sessop_flag =
| AllOrNothing of unit
| MultLimit of int
| Unlimited of unit

type sess_op =
| SessCreate of string
| SessWait of string
| SessSig of string * sess_sig
| SessDestroy of string

| SessCreateSuccess of string * string
| SessWaitSuccess of string
| SessSigSuccess of string * sess_sig
| SessDestroySuccess of string
| SessOpFailure of string * sess_opname * string

| ProcCreate of string * command array array * string array
	* (Db.dbop * Db.attrval) list array * (string * Db.dbval) list
	* sessop_flag
| ProcWait of string * string
| ProcSig of string * string * sess_sig

| ProcCreateSuccess of string * sessproc array
| ProcWaitSuccess of string * string
| ProcSigSuccess of string * string * sess_sig
| ProcOpFailure of string * sess_opname * string
| OpFailure of string

(* administrative operations *)
| DBGetEntry of Db.attrval
| DBDeleteEntry of Db.attrval
| DBChangeAttributes of Db.attrval * Db.attrval list
| Shutdown of unit

| DBGetEntryReply of Db.attrval * Db.dbentry
| DBDeleteEntryOk of Db.attrval
| DBChangeAttributesOk of Db.attrval
| ShutdownOk of unit

(**************************************************************)

val sesslist_create : unit -> sesslist 

val sess_create : sesslist -> string -> session 
val sess_destroy : sesslist -> string -> unit
val sess_lookup : sesslist -> string -> session
val sess_lookup_incticket : sesslist -> string -> int -> session 

val sess_processes_clear : sesslist -> string -> unit 
val sess_proc_add : sesslist -> string -> sessproc -> session
val sess_proc_remove : sesslist -> string -> string -> unit
val sess_proc_lookup : sesslist -> string -> string -> sessproc

val sess_req_add : sesslist -> string -> sess_opname
	-> Rpc.Sockio.request_id -> int -> session 
val sess_req_remove : sesslist -> string -> int -> unit 
val sess_req_lookup : sesslist -> string -> int -> sessreq 
val sess_req_lookup_decntowait : sesslist -> string -> int -> sessreq 
val sess_req_lookup_decntowait_addproc : sesslist -> string
	-> int -> sessproc -> sessreq 

(**************************************************************)
