(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* REXEC.ML: *)
(* Execute command on a remote machine with a particular
 * set of environemnt variables.  Usage:
 *
 *	rscript machinename machinetype ostype command
 *
 * Modify construct_env for a different set of environement variables.
 *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)
let construct_env () = (
    "setenv ENS_ID shared ; 
     setenv ENS_MODES UDP ;
     setenv ENS_PORT 9870 ;
     setenv ENS_EXECSVR_HOSTS eclair0:eclair1 ;
     setenv ENS_EXECSVR_PORT 9872 ;
     setenv ENS_DBDEFAULT /usr/u/ensemble/ensemble/execsvr/dbdefault ;
     setenv ENS_GROUPD_HOSTS gulag:eclair0:eclair1 ;
     setenv ENS_GROUPD_PORT 9874 ;
     setenv ENS_GOSSIP_HOSTS eclair0:eclair1 ;
     setenv ENS_GOSSIP_PORT 9876 ; "
)
in

try
  let machine = Sys.argv.(1)
  and machtype = Sys.argv.(2)
  and ostype = Sys.argv.(3)
  and command = Sys.argv.(4)
  and env = construct_env ()
  in
  let cmd = "nice +19 /usr/u/ensemble/bin/"
    ^ machtype ^ "-" ^ ostype ^ "/" ^ command ^ " -groupd"
    (* ^ " -trace MANAGE" *)
  in

  let rshcmd = "/usr/ucb/rsh"
  in
  let rshargs = Array.create 2 "" in
  rshargs.(0) <- machine ;
  rshargs.(1) <- env ^ cmd ;

  Printf.printf "starting %s on %s\n" cmd machine ;
  Pervasives.flush stdout ;
  (try
     Unix.execv rshcmd rshargs
  with Unix.Unix_error(err, _, _) ->
     Printf.printf "exec failed: %s\n" (Unix.error_message err)
  )
with exn -> (try Printexc.print (function () -> raise exn) () with _ -> ())
;;
