(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(* This is the type of the error delivery function.
 *)
type error = string -> unit

(* This type is a function that is used to deliver marshalled messages.
 *)
type deliver = string -> unit

(* An instance of an object is defined by the following type:
 *)
type ('r, 'u, 's) instance = {
  read: 'r -> unit;
  update: 'u -> unit;
  destroy: (unit -> unit) -> error -> unit;
  get_state: ('s -> unit) -> error -> unit
}

(* "install name create" makes an object class of the the given name.
 * `create' is a function that takes either None (for default), or
 * Some initial_state, to create an instance of that object.
 *)
val install : string -> ('s option -> ('r, 'u, 's) instance) -> unit

(* "create send name upcall error" creates an instance of the named
 * object class, which is delivered using the given upcall.  The given
 * error function is invoked when something goes wrong.  The send
 * function is the function that is used to send the request.
 *)
val create : deliver -> string ->
  (('r, 'u, 's) instance -> unit) -> error -> unit

(* "got_request send message" has to be invoked when a request message
 * arrives (sent by the send function specified in "create").  The send
 * function specified here is used to send the response back.
 *)
val got_request : deliver -> deliver

(* This function has to be invoked when a reply is received.
 *)
val got_reply : deliver
