(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* PROCESS.ML *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)

type sess_or_proc =
| Sess
| Proc

type process = {
    psessname		: string ;
    procname		: string ;
    program		: string ;
    procenv		: string array ;
    procsvr		: Ensemble.Endpt.id ;

    handle              : Socket.process_handle ;
    starttime		: float ;
    mutable procrid	: Rpc.Sockio.request_id option ;
    mutable waitreqid	: int ;
    mutable waitoptype  : sess_or_proc ;
    mutable waitendpt	: Ensemble.Endpt.id option
}

(**************************************************************)

val proc_exec_list : process list ref
val proc_done_list : process list ref

(**************************************************************)

val proc_exec_create : string -> string -> string array
	-> Ensemble.Endpt.id -> Socket.process_handle -> string -> process 
val proc_done_add : process -> unit
val proc_move_to_done : Socket.process_handle -> process
val proc_remove : string -> string -> process list ref -> process
val proc_exec_remove : string -> string -> process
val proc_done_remove : string -> string -> process

val proc_lookup : string -> string -> process list -> process
val proc_exec_lookup : string -> string -> process
val proc_done_lookup : string -> string -> process

val proc_list_print : string -> process list -> unit 
val proc_exec_list_print : unit -> unit
val proc_done_list_print : unit -> unit

val kill_all_procs : unit -> unit 
val toseprocess : process -> Session.sessproc

(**************************************************************)
