(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(* These functions operate on values of type
 *	CONSTRUCTOR of Obj.t * (Obj.t -> unit) * (Obj.t -> unit)
 *
 * The values are used to specify a request type, an argument to the
 * request, a function to deliver the response, and another to deliver
 * an error in case something went wrong.
 * For example,
 *
 *	type 'a queue = ENQUEUE of 'a * (unit -> unit) * (string -> unit)
 *		      | DEQUEUE of unit * ('a -> unit) * (string -> unit)
 *
 * with values like ENQUEUE("hello", upcall, error), where the request is
 * to enqueue the string "hello", and to invoke upcall when done.  These
 * constructors can be used to create type safe request/response pairs.
 *)

type upcall = Obj.t -> unit

(* Unpack takes a value, and returns the tag and the three arguments of
 * the constructor.
 *)
val unpack : Obj.t -> (int * Obj.t * upcall * upcall)

(* Pack takes a tag and three arguments to create a value.
 *)
val pack : int -> Obj.t -> upcall -> upcall -> Obj.t
