(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
type upcall = Obj.t -> unit

let closure = Obj.tag (Obj.repr (fun () -> ()))

let check x =
  if not (Obj.is_block x) then
    failwith "pack: not a block";
  if (Obj.tag x) <> closure then
    failwith "pack: not a closure"

let pack tag request reply error =
  let reply = Obj.repr reply and error = Obj.repr error in
  check reply; check error;
  let o = Obj.new_block tag 3 in
  Obj.set_field o 0 request;
  Obj.set_field o 1 reply;
  Obj.set_field o 2 error;
  o

let unpack r =
  if not (Obj.is_block r) then
    failwith "unpack: not a block";
  if (Obj.size r) <> 3 then
    failwith "unpack: bad size";
  let f i = Obj.field r i in
  check (f 1); check (f 2);
  (Obj.tag r, f 0, (Obj.magic (f 1)), (Obj.magic (f 2)))
