(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* LEXEC.ML: *)
(* Execute a command with a particular set of environemnt variables.
 * Fix ensemble_eq for a different set of environement variables.
 *
 * Usage: lexec command args
 *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)
let construct_env () = (
  let ensemble_eq = (
    ["ENS_ID=shared";
     "ENS_MODES=UDP" ;
     "ENS_PORT=9870" ;
     "ENS_EXECSVR_HOSTS=eclair0:eclair1" ;
     "ENS_EXECSVR_PORT=9872";
     "ENS_DBDEFAULT=/usr/u/ensemble/ensemble/execsvr/dbdefault";
     "ENS_GROUPD_HOSTS=gulag:eclair0:eclair1" ;
     "ENS_GROUPD_PORT=9874" ;
     "ENS_GOSSIP_HOSTS=eclair0:eclair1" ;
     "ENS_GOSSIP_PORT=9876"]
  )
  in

  let ensemble_var equality = (
    if (equality.[0] = 'E'
      & equality.[1] = 'N'
      & equality.[2] = 'S'
      & equality.[3] = '_') then
      true
    else
      false
  )
  in
  
  let rec remove_ensemble_eq = function
    | [] -> []
    | h::t ->
        if (ensemble_var h) then
          (remove_ensemble_eq t)
        else
          (h::(remove_ensemble_eq t))
  in

  let env = Array.to_list (Unix.environment ()) in
  let env = remove_ensemble_eq env in
  let env = (env @ ensemble_eq) in
  Array.of_list env
) ;;

(try
  let cmd = Sys.argv.(1)
  and alist = List.tl (List.tl (Array.to_list Sys.argv))
  and env = construct_env ()
  and machtype = Sys.getenv "MACHTYPE"
  and ostype = Sys.getenv "OSTYPE"
  in
  let command =
     "/usr/u/ensemble/bin/" ^ machtype ^ "-" ^ ostype ^ "/" ^ cmd
  in
  let args = Array.of_list (cmd::alist) in

  (try
     Printf.printf "executing %s\n" command ;
     Pervasives.flush stdout ;
     Unix.execve command args env
   with Unix.Unix_error(err, _, _) ->
     Printf.printf "execve failed: %s\n" (Unix.error_message err)
  )
with exn -> (try Printexc.print (function () -> raise exn) () with _ -> ()))
