(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DUTIL.ML: utility module *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)

type svr_type =
| SvrSess
| SvrProc

type svr_state = {
  sttype                        : svr_type ;
  stname                        : string ;
  mutable stendpt               : Ensemble.Endpt.id option ;

  mutable staticentry           : Db.dbentry ;
  mutable nrunning              : int ;
  mutable nwaiting              : int ;
  mutable ncompleted            : int ;
  mutable gossipid              : int ;
  mutable stload                : float ;
  mutable stuptime              : float ;

  mutable strestrictions        : Db.dbrestrictions 
}

type execsvr_msg =
  | DSessWait of string * int * string
  | DSessSig of string * int * string * Session.sess_sig

  | DSessWaitSuccess of string * int * string
  | DSessSigSuccess of string * int * string * Session.sess_sig
  | DSessOpFailure of string * int * Session.sess_opname * string


  | DProcCreate of string * int * string * string array * int
  | DProcWait of string * int * string
  | DProcSig of string * int * string * Session.sess_sig * Rpc.Sockio.request_id

  | DProcCreateSuccess of string * int * Session.sessproc
  | DProcWaitSuccess of string * int * string
  | DProcSigSuccess of string * int * string * Session.sess_sig * Rpc.Sockio.request_id
  | DProcOpFailure of string * int * Session.sess_opname * string

  | DDBDeleteEntry of Db.attrval
  | DDBChangeAttributes of Db.attrval * Db.attrval list

  | DDBDeleteEntryOk of Db.attrval
  | DDBChangeAttributesOk of Db.attrval

  | DShutdown of unit
  | DUpQuery of unit
  | DUpAnswer of svr_type * string * float * float * int
  | DGossip of string * float * Db.dbentry

(**************************************************************)

val convert_uptime : float -> int * int * int * int
val compose_dbentry : svr_state -> Db.dbentry
val print_uptime : svr_type -> string -> float -> float -> int -> unit 
val print_msghdr : execsvr_msg -> unit 

(**************************************************************)
