(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DBINPUT.ML: Database input *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)
open Ensemble
open Str
open Db
(**************************************************************)

let dbdefault = (try
  Sys.getenv "ENS_DBDEFAULT"
with _ ->
  "dbdefault"
)

let read_dbdefault () = (
  let slist = ref [] in
  (try
    let chan = open_in dbdefault in
    let len = in_channel_length chan in
    let buffer = String.create len in
    let nchar = input chan buffer 0 len in
    (
      slist := (Str.split (regexp "[\n]+") buffer) ;
      close_in chan ;
      Util.printf "DBINPUT: read %d machine entries from %s\n"
        (List.length !slist) dbdefault ;
      !slist
    )
  with _ -> (
    Util.printf "file %s does not exist.\n" dbdefault ;
    raise Not_found
  ))
)

let get_index machine_name slist =
  let comp_addr h1 h2 =
    (try
      let addr1 = (Unix.gethostbyname h1).Unix.h_addr_list.(0) in
      let addr2 = (Unix.gethostbyname h2).Unix.h_addr_list.(0) in
      (addr1 = addr2)
     with _ -> false)
  in
  let rec loop i = function
  | [] -> raise Not_found
  | h::t ->
      let entry = Array.of_list (Str.split (regexp "[=]+") h) in
      if Array.length entry = 2 & entry.(0) = "name" &
        (comp_addr machine_name entry.(1)) then
        i
      else
        loop (i + 1) t
  in
  loop 0 slist

let parse_entry slist start = (
   let nextentry = ref false in
   let entry = Array.of_list (Str.split (regexp "[=]+") slist.(start)) in
   let dlist = 
     (if Array.length entry = 2 then
       ref [(entry.(0), String entry.(1))]
     else
       ref [])
   in
   let i = ref (start + 1) in
   let max = Array.length slist in
   while not !nextentry & !i < max do
     let entry = Array.of_list (Str.split (regexp "[=]+") slist.(!i)) in
     if Array.length entry = 2 then (
       if entry.(0) = "name" then
         nextentry := true
       else (
   Util.printf "adding %s %s\n" entry.(0) entry.(1) ;
         (* TODO: add mechanism for adding in restrictions *)
(*
         if entry.(0) = "restriction" then (
           let r = Array.of_list (Str.split (regexp "[;]+") entry.(1)) in
           let l = ref [] in
           for j = 0 to (Array.length r) - 1 do
             let e = Array.of_list (Str.split (regexp "[,]+") r.(j)) in
             if Array.length e = 3 then (
               if e.(0) = "only" then (
   Util.printf "adding restriction only %s %s\n" e.(1) e.(2) ;
                 l := !l @ [(Only, e.(1), e.(2))] ;
               )
               else (
   Util.printf "adding restriction priority %s %s\n" e.(1) e.(2) ;
                 l := !l @ [(Priority, e.(1), e.(2))] ;
               )
             )
           done ;
           dlist := !dlist @ [entry.(0), Restrict !l]
         )
         else
*)
           dlist := !dlist @ [(entry.(0), String entry.(1))]
       )
     ) ;
     i := !i + 1 ;
   done ;
   !dlist
)

let read_entry machine_name =
  (try
     let slist = read_dbdefault () in
     let start = get_index machine_name slist in
     let l = parse_entry (Array.of_list slist) start in
     l
   with Not_found -> (
     Util.printf "entry for %s not found\n" machine_name ;
     [])
  )
