(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* DB.MLI: Database  *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)

type dbop =
| DBeq
| DBlt
| DBgt
| DBlteq
| DBgteq
| DBinclude of string
| DBrandom of int
| DBmin of int			(* Expensive. Scans entire DB. *)

type dbtype =
| DBmachine
| DBprocess

type dbval =
| String of string
| Int of int
| Float of float
| Endpt of Ensemble.Endpt.id
| Addr of Unix.inet_addr
| StrList of string list
| Noval
type attrval = string * dbval

type dbentry = attrval list
type dbrestrictions = (dbop * dbtype * string * dbval) list

(**************************************************************)

val db : dbentry list ref
val restrictions : (string * dbrestrictions) list ref

(**************************************************************)

val getdbval : string -> (string * dbval) list -> dbval
val dbentry_print : dbentry -> unit
val db_init : int -> unit
val db_add : dbentry -> unit
val db_delete : dbop * (string * dbval) -> unit
val db_change : attrval -> attrval list -> unit
val db_select : (dbop * (string * dbval)) list -> dbentry list
val db_select_project : (dbop * (string * dbval)) list -> string -> dbval list
val db_select_with_restrict : (dbop * (string * dbval)) list -> attrval list -> dbentry list
val db_restrict : attrval list -> dbentry list -> dbentry list
val db_random : int -> dbentry list -> bool -> attrval list -> dbentry list
val db_print : unit -> unit

val db_restrictions_add : string -> dbrestrictions -> unit
val db_restrictions_delete : string -> unit
val db_restrictions_lookup : string -> string * dbrestrictions

(**************************************************************)
