(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* CLIENTREQ.MLI: queue for client reqeusts *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)

type clreq_status =
| CR_unassigned
| CR_assinged of Ensemble.Endpt.id	(* sessvr who has it *)

type clreq_q = {
  crid		: int ;
  crreq		: Session.sess_op ;
  crrid		: Rpc.Sockio.request_id ;
  crstatus	: clreq_status
}

val crq_unassigned_add_new : Rpc.Sockio.request_id -> Session.sess_op -> unit
val crq_assign_next : unit -> clreq_q
val crq_lookup_and_remove : clreq_q list ref -> int -> clreq_q
val crq_add_old : clreq_q list ref -> clreq_q -> unit

(**************************************************************)
