(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* CLIENTREQ.ML: queue for client reqeusts *)
(* Author: Takako M. Hickey, 4/97 *)
(**************************************************************)
open Ensemble
(**************************************************************)

type clreq_status =
| CR_unassigned
| CR_assinged of Ensemble.Endpt.id	(* sessvr who has it *)

type clreq_q = {
  crid		: int ;
  crreq		: Session.sess_op ;
  crrid		: Rpc.Sockio.request_id ;
  crstatus	: clreq_status
}

let crq_ticket = ref 0
let crq_unassigned = ref []
let crq_assigned = ref []

let crq_unassigned_add_new rid req =
  crq_ticket := !crq_ticket + 1 ;
  let cr = {
    crid = !crq_ticket ;
    crreq = req ;
    crrid = rid ;
    crstatus = CR_unassigned
  } in
  crq_unassigned := !crq_unassigned @ [cr]

let crq_assign_next () =
  if !crq_unassigned = [] then
    raise Queue.Empty ;
  let h = List.hd !crq_unassigned in
  crq_unassigned := List.tl !crq_unassigned ;
  crq_assigned := !crq_assigned @ [h] ;
  h

(* Look up request with given id from given queue and remove it.
 *)
let crq_lookup_and_remove q id =
  let ans = (ref None: clreq_q option ref) in
  let rec loop = function
    | [] -> raise Not_found
    | h::t ->
        if h.crid = id then (
          ans := Some h ;
          t
        )
        else
          h::(loop t)
  in
    q := loop !q ;
    (match !ans with
     | Some a -> a
     | None -> raise Not_found
    )

(* Add in by crid order.  Used when request is reassigned to
 * another sessvr due to failure etc.
 *)
let crq_add_old q cr =
  let rec loop = function
    | [] -> [cr]
    | h::t ->
        if cr.crid < h.crid then
          cr::(h::t)
        else
          h::(loop t)
  in
    q := loop !q
