/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
#ifndef ENSEMBLE_OS_HH
#define ENSEMBLE_OS_HH
//
// $Id: EnsembleOS.hh,v 1.0 1997/02/27 12:05:00 atre, sachdeva Exp $
//
// Authors: Anil Sachdeva, Anand Atre. anil@cs.cornell.edu, 
// atre@cs.cornell.edu
// Copyright (c) 1997 by Anil Sachdeva, Anand Atre. anil@cs.cornell.edu, 
// atre@cs.cornell.edu
// All rights reserved.
//
// THIS IS FREE SOFTWARE.
// Permission to use, copy, modify, and distribute this software and 
// documentation in all settings is hereby granted, provided that no fee is 
// charged for this software and provided that this copyright notice appears 
// in all copies of any software which is or includes a copy or modification 
// of this software. In all advertising materials, documentation, and 
// publications mentioning features or use of this software you must credit 
// the author.
//
// This software is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of merchantability 
// or fitness for a particular purpose. 
//

// Declaration of a VirtualOS subclass. The Electra Stream class 
// (cin, cout, cerr are instances of it) relies on the file operations
// of class VirtualOS. This to permit you to exploit nonblocking I/O
// libraries which are part of many subsystems. 
//
// The motivation for this is that the conventional C++ streams 
// suspend the whole unix process especially when waiting for input.
// A subsystem like Horus or Isis will assume that such a waiting process
// has crashed, since it does not respond to "are-you-alive" messages any more.
//
// BSDOS is a direct subclass of VirtualOS that relies upon a BSD like
// libc library. If you are working on SYSV, you might
// have to implement a SYSV subclass, by adapting the code of class BSDOS.
// (should be easy).
//
// Probably, you will only have to implement the fileRead operation.
// The rest can be inherited from BSDOS.


class EnsembleOS: public BSDOS {
public:
  virtual void   handleEvents() {};
  virtual Short  timeAlarm(ULong MSecs, void (*)(Short, void *), void *Arg);
  virtual void   timeAlarmCancel(Short Tid);

  // these are pure virtual functions which must be overriden
  virtual Status fileInputHdlr(int, void **, inputHdlr, void *);
  virtual Status fileInputHdlrCancel(void *);
  virtual Status interceptSet(int Fd);
  virtual Status interceptCancel(int Fd);

protected:
  const int MAX_TIMERS=10;

  struct TimeAlarmStruct {
    TimeAlarmStruct() {
      TimerId = MAX_TIMERS;
      MSecs = 0;
      ExecuteFunc = 0;
      FuncArg = 0; 
      IsActive = FALSE;
      IsFree = TRUE; 
    }
    Short TimerId; 
    ULong MSecs;
    void (*ExecuteFunc)(Short, void*);
    void *FuncArg; 
    Boolean IsActive; 
    Boolean IsFree; 
  };
  
  static TimeAlarmStruct timers[MAX_TIMERS];
  
  static void timeAlarmUpcall(void *Env);

};
#endif
