/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
//
// $Id: EnsembleOS.cc,v 1.1 1997/02/27 12:05:00 atre, sachdeva Exp $
//
// Authors: Anil Sachdeva, Anand Atre. anil@cs.cornell.edu, 
// atre@cs.cornell.edu
// Copyright (c) 1997 by Anil Sachdeva, Anand Atre. anil@cs.cornell.edu, 
// anand@cs.cornell.edu
// All rights reserved.
//
// THIS IS FREE SOFTWARE.
// Permission to use, copy, modify, and distribute this software and 
// documentation in all settings is hereby granted, provided that no fee is 
// charged for this software and provided that this copyright notice appears 
// in all copies of any software which is or includes a copy or modification 
// of this software. In all advertising materials, documentation, and 
// publications mentioning features or use of this software you must credit 
// the author.
//
// This software is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of merchantability 
// or fitness for a particular purpose. 
//

extern "C"{
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
}

#include <osfcn.h>

#include "orb/CORBA.h"
#include "machdep/BSDOS.hh"
#include "EnsembleOS.hh"
#include "Maestro_Types.h"

// static member declaration
EnsembleOS::TimeAlarmStruct EnsembleOS::timers[MAX_TIMERS];

void EnsembleOS::timeAlarmUpcall(void *Env) {
  TimeAlarmStruct *TS = (TimeAlarmStruct *)Env;
  while(TS->IsActive){
    Maestro_Thread::usleep(TS->MSecs * 1000);    
    (*TS->ExecuteFunc)(TS->TimerId, TS->FuncArg);
  }
  TS->IsFree = TRUE;
}

Short EnsembleOS::timeAlarm(ULong MSecs, void (*F)(Short, void *), 
			    void *Arg) {
  Short Tid;

  for(Tid=0; Tid < MAX_TIMERS; Tid++)
    if(timers[Tid].IsFree) 
      break;
  
  if(Tid == MAX_TIMERS)
    gLog->panic("EnsembleOS::timeAlarm: too many timers. Limit is %d", 
		MAX_TIMERS);
  
  timers[Tid].TimerId = Tid;
  timers[Tid].MSecs = MSecs; 
  timers[Tid].ExecuteFunc = F; 
  timers[Tid].FuncArg = Arg; 
  timers[Tid].IsActive = TRUE;
  timers[Tid].IsFree = FALSE;
  
  Maestro_ThreadOps ThOps;
  ThOps.stackSize = 2048;

  Maestro_Thread::create(timeAlarmUpcall, (void *)&timers[Tid], &ThOps);

  return Tid++;
}

void
EnsembleOS:: timeAlarmCancel(Short Tid){
  if(Tid < MAX_TIMERS) 
    timers[Tid].IsActive = FALSE;
}

// pure virtual functions which must be overriden by this class
Status EnsembleOS::fileInputHdlr(int, void **, 
				 VirtualOS::inputHdlr, void *) {
  gLog->panic("EnsembleOS::fileInputHdlr: not implemented!");
  return ST_OK;
}

Status EnsembleOS::fileInputHdlrCancel(void *){
  gLog->panic("EnsembleOS::fileInputHdlrCancel: not implemented");
  return ST_OK;
}

Status EnsembleOS::interceptSet(int){
  return ST_OK;
};

Status EnsembleOS::interceptCancel(int){
  return ST_OK;
}


