/**************************************************************/
/*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 */
/**************************************************************/
//
// $Id: Adaptor.cc,v 1.0 1997/02/08 15:03:47 sachdeva,atre Exp $
//
// Authors: Anand Atre, Anil Sachdeva.  atre@cs.cornell.edu, 
// anil@cs.cornell.edu.
// Copyright (c) 1997 by Anand Atre, Anil Sachdeva.  anand@cs.cornell.edu, 
// anil@cs.cornell.edu.
// All rights reserved.
//
// THIS IS FREE SOFTWARE.
// Permission to use, copy, modify, and distribute this software and 
// documentation in all settings is hereby granted, provided that no fee is 
// charged for this software and provided that this copyright notice appears 
// in all copies of any software which is or includes a copy or modification 
// of this software. In all advertising materials, documentation, and 
// publications mentioning features or use of this software you must credit 
// the author.
//
// This software is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of merchantability 
// or fitness for a particular purpose. 
//
//

// This file contains the platform dependent code that starts up 
// an adaptor and performs initializations.

extern "C" {
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
}

#include "vmachine/Electra.hh"
#include "orb/CORBA.h"
#include "iiop/IIOPBridge.hh"
#include "iiop/IIOPClient.hh"
#include "machdep/BSDOS.hh"

#include "EnsembleOS.hh"
#include "Ensemble_MaestroAD.hh"

extern CORBA::ORB_ptr Electra_ORB;
extern CORBA::BOA_ptr Electra_BOA;
extern const char *gUtilName;

///////////////////////////////////////////////////////////
//
// Adaptors and utility objects:
//

VirtualOS *os;                       // OS adaptor.
VirtualMachine *ad;                  // platform adaptor.
RpcLayer *rpc;                       // The RPC module.
Log *gLog;                           // Logging facility.
IIOPClient *gIIOP;                   // Internet ORB bridge

///////////////////////////////////////////////////////////
//
// Initialization etc.:
//

void init_adaptors(){
  int pid;

  // create the operating system adaptor:
  os = new EnsembleOS;

  // create the logging facility:
  os->processGetPid(pid);

  char *usrLogDir=0;
  usrLogDir  = getenv("ELECTRA_LOGDIR");

  if (!usrLogDir)
    gLog = new Log(Util::buildPath(gElectraHome, "/etc/log/", gHostName, 
				   ".", gUtilName, ".log"));
  else
    gLog = new Log(Util::buildPath(usrLogDir,"/", gHostName, ".", 
				   gUtilName, ".log"));

  // create the platform adaptor and initialize it:
  //
  ad = new Ensemble_MaestroAD("Ensemble_MaestroAD");

  // create the other electra modules:
  //
  rpc = new RpcLayer;
  gIIOP = new IIOPClient;
}

// invoked when an application terminates:
//
void quit_adaptors(){
  if(Electra_ORB) delete Electra_ORB;
  if(Electra_BOA) delete Electra_BOA;
  ad->machQuit();
  if(rpc) delete rpc;
  if(gIIOP) delete gIIOP;
  if(gLog) delete gLog;
  if(ad) delete ad;
  if(os) delete os;
}

// the main body. Performs initializations:
//
main(int argc, char** argv) {  

  Util::electraInit(argc, argv);
 
  // Create adaptor, trader, etc.:
  init_adaptors();
  Electra_ORB = new CORBA::ORB;
  Electra_BOA = new CORBA::BOA(FALSE);
  ad->machInit();

  cerr << "Goodbye!" << endl;
  return 0;
}
