(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* GROUPD.ML *)
(* Author: Mark Hayden, 8/95 *)
(**************************************************************)
open Ensemble
open Hsys
open Util
open Trans
open View
open Appl_intf
(**************************************************************)
let name = Trace.source_file "GROUPD"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let run () =
  let nice = ref false in
  (*
   * Parse command line arguments.
   *)
  Arge.parse [
    (*
     * Extra arguments can go here.
     *)
    "-nice", Arg.Set(nice), "use minimal resources"
  ] (Arge.badarg name) "groupd server" ;

  (*
   * Get default transport and alarm info.
   *)
  let (ls,vs) = Appl.default_info "groupd" in
  let vs =
    if not !nice then vs else 
      View.set vs [
        Vs_params([
	  "pr_stable_sweep",Param.Time(Time.of_float 3.0) ;
	  "pr_stable_fanout",Param.Int(5) ;
	  "pr_suspect_sweep",Param.Time(Time.of_float 3.0) ;
	  "pr_suspect_max_idle",Param.Int(20) ;
	  "pr_suspect_fanout",Param.Int(5) ;
	  "merge_sweep",Param.Time(Time.of_float 3.0) ;
	  "merge_timeout",Param.Time(Time.of_float 150.0) ;
	  "top_sweep",Param.Time(Time.of_float 10.0)
        ])]
  in

  (* Get the port number to use from the argument module.
   *)
  let port = Arge.check name Arge.groupd_port in

  (* Initialize the Maestro stack.
   *)
  let manager, (ls,vs), interface = Manage.create (ls,vs) in
  Appl.config interface (ls,vs) ;
  Manage.proxy_server manager port ;

  (*
   * Enter a main loop
   *)
  Appl.main_loop ()
  (* end of run function *)


(* Run the application, with exception handlers to catch any
 * problems that might occur.
 *)
let _ = Appl.exec ["groupd"] run

(**************************************************************)
