(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* GOSSIP.ML: server side of gossip transport *)
(* Author: Mark Hayden, 8/95 *)
(**************************************************************)
open Ensemble
(**************************************************************)
let name = Trace.source_file "GOSSIP"
let failwith s = failwith (Util.failmsg name s)
(**************************************************************)

let run () =
  (*
   * Parse command line arguments.
   *)
  Arge.parse [
    (*
     * Extra arguments go here.
     *)
  ] (Arge.badarg name) "gossip server" ;

  (*
   * Get default transport and alarm info.
   *)
  let view_state = Appl.default_info "gossip" in

  (* Get the port number to use from the argument module.
   *)
  let port = Arge.check name Arge.gossip_port in

  (* Initialize the Gossip stack.
   *)
  let view_state, interface = Reflect.init view_state port false in
  Appl.config interface view_state ;

  (*
   * Enter a main loop
   *)
  Appl.main_loop ()
  (* end of run function *)

(* Run the application, with exception handlers to catch any
 * problems that might occur.
 *)
let _ = Appl.exec ["gossip"] run

(**************************************************************)
