(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* EARG.MLI *)
(* Author: Mark Hayden, 4/96 *)
(**************************************************************)
open Trans
(**************************************************************)

type 'a t

(* Get and set parameters.
 *)
val get : 'a t -> 'a
val set_default : 'a t -> string -> unit

(* Check an option parameter to make sure it has been set.
 *)
val check : debug -> 'a option t -> 'a

(**************************************************************)
(* These are the parameter variables set by this module.
 *)

val aggregate    : bool t		(* aggregate messages *)
val alarm	 : Alarm.id t		(* alarm to use *)
val force_modes	 : bool t		(* force modes, no matter what *)
val gossip_hosts : Hsys.inet list option t (* where to find gossip servers *)
val gossip_port  : Trans.port option t	(* where to find gossip server *)
val group_name	 : string t		(* default group name *)
val groupd       : bool t		(* use groupd server? *)
val groupd_balance : bool t		(* load balance groupd servers? *)
val groupd_hosts : Hsys.inet list option t (* where to find groupd servers *)
val groupd_port  : Trans.port option t	(* TCP port to use for groupd *)
val id           : string t		(* user id for application *)
val key		 : string option t	(* security key to use *)
val log          : bool t		(* use log server? *)
val log_host     : Hsys.inet option t	(* where to find log server *)
val log_port     : Trans.port option t	(* TCP port to use for log *)
val modes	 : Addr.id list t	(* default modes to use *)
val nmembers	 : int t		(* default number of members *)
val port         : Trans.port option t	(* primary UDP/TCP port *)
val properties   : Property.id list t	(* default protocol properties *)
val quiet        : bool t		(* enable quiet execution *)
val refcount     : bool t		(* use reference counts for iovecs *)
val roots	 : bool t		(* output resource info? *)
val sp2_suffixes : string list t	(* suffixes to hostname for SP2 fast interconnect *)
val glue         : Glue.glue t		(* selected layer glue. *)
val pgp          : string option t	(* are we using pgp? *)
val pollcount    : int t		(* number of failed polls before blocking *)
val multiread    : bool t		(* do we read all data from sockets? *)
val sched_step   : int t		(* number of events to schedule per step *)
val udp_host     : Hsys.inet option t	(* hostname to use for UDP communication *)

val perturb	 : bool t
val perturb_rate : float t
val perturb_doze : Time.t t

(**************************************************************)

val check_port   : name -> port -> unit	(* check if port is in range *)

(**************************************************************)

(* Returns sorted list of default Ensemble command-line arguments.
 *)
val args 	: unit -> (string * Arg.spec * string) list

(* Takes application arguments and parses them along with
 * the Ensemble arguments.
 *)
val parse	: (string * Arg.spec * string) list -> (string -> unit) -> string -> unit

(* Can be used for capturing command-line problems.
 *)
val badarg 	: string -> string -> unit

(**************************************************************)

val stats : unit -> unit

(**************************************************************)
