(**************************************************************)
(*
 *  Ensemble, (Version 0.40)
 *  Copyright 1997 Cornell University
 *  All rights reserved.
 *
 *  See ensemble/doc/license.txt for further information.
 *)
(**************************************************************)
(**************************************************************)
(* APPL.MLI *)
(* Author: Mark Hayden, 4/95 *)
(**************************************************************)

(* Top-level scheduler.
 *)
val root_sched : Sched.t

(* Get a list of addresses for this process.
 *)
val addr :
  Addr.id list -> 
  Addr.set

(* Create default view state information for singleton member.
 *)
val default_info :
  string ->				(* application name *)
  View.full

(* Create view state information for singleton members, but
 * you can give more information than default_info.
 *)
val full_info :
  string ->				(* application name *)
  bool ->				(* remote membership svc? *)
  Proto.id ->				(* protocol stack to use *)
  (Addr.id list) ->			(* modes to use *)
  Security.key ->			(* key to use *)
  View.full


(* Main loop of Ensemble.  Never returns.
 *)
val main_loop : unit -> unit

(* Execute main function if application has one of the
 * specified names.  Works for various operating systems.
 *)
val exec :
  string list ->			(* application names *)
  (unit -> unit) ->			(* main function *)
  unit

(* Configure a stack.  Supports normal stacks and domain stacks.
 *)
val config :
  Appl_intf.t ->			(* application *)
  View.full ->				(* view state *)
  unit

(* Request an asynchronous event for an application.
 *)
val async :
  (Group.id * Endpt.id) ->		(* Id of application *)
  (unit -> unit)			(* request function *)

(**************************************************************)

val perturb :
  Alarm.t -> Time.t -> float -> (unit -> unit)

val main_loop_opt : unit -> unit
val init_groupd : unit -> (unit,unit) Manage.t (* for perf tests *)
val start_monitor : unit -> unit

(**************************************************************)
