/*
 * Decompiled with CFR 0.152.
 */
package obj2msh;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Point3i;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import obj2msh.GroupData;
import obj2msh.OBJLoaderException;

public class OBJLoader {
    protected Vector<Vector3f> vertexList = new Vector();
    protected Vector<Vector3f> normalList = new Vector();
    protected Vector<int[]> indexList = new Vector();
    protected Vector<Vector2f> texcoordList = new Vector();
    protected Vector<String> fileString = new Vector();
    protected String objectName;
    protected String materialName;
    protected Vector<GroupData> groupList = new Vector();

    public OBJLoader(String filename) throws IOException, OBJLoaderException {
        this.loadFile(filename, true);
    }

    public OBJLoader(String filename, boolean normalize) throws IOException, OBJLoaderException {
        this.loadFile(filename, normalize);
    }

    /*
     * Unable to fully structure code
     */
    protected void loadFile(String filename, boolean normalize) throws IOException, OBJLoaderException {
        f = new File(filename);
        try {
            fr = new FileReader(f);
            reader = new BufferedReader(fr);
            if (true) ** GOTO lbl11
        }
        catch (IOException e) {
            throw new IOException(e + "\nUnable to create FileReader: File may not be a text file");
        }
        do {
            this.fileString.add(s);
lbl11:
            // 2 sources

        } while ((s = reader.readLine()) != null);
        reader.close();
        this.parseFile();
        if (this.normalList.size() == 0) {
            this.computeNormals();
        }
        if (normalize) {
            this.normalize();
        }
        this.expandGroups();
        this.repOK();
        if (this.vertexList.size() <= 0) {
            throw new OBJLoaderException("Error: No vertices found.\nFile may not be a valid .OBJ file.");
        }
    }

    protected void parseFile() throws OBJLoaderException {
        String firstToken;
        Vector3f v;
        double z;
        double y;
        double x;
        String firstToken2;
        StringTokenizer st;
        Vector<Vector3f> vlist = new Vector<Vector3f>();
        Vector<Vector3f> nlist = new Vector<Vector3f>();
        Vector<Vector2f> tlist = new Vector<Vector2f>();
        for (String currToken : this.fileString) {
            st = new StringTokenizer(currToken);
            while (st.hasMoreTokens()) {
                firstToken2 = st.nextToken();
                if (!firstToken2.equals("v")) continue;
                if (st.countTokens() != 3) {
                    throw new OBJLoaderException("Invalid number of params for v: " + st.countTokens());
                }
                x = Double.parseDouble(st.nextToken());
                y = Double.parseDouble(st.nextToken());
                z = Double.parseDouble(st.nextToken());
                v = new Vector3f((float)x, (float)y, (float)z);
                vlist.add(v);
            }
        }
        for (String currToken : this.fileString) {
            st = new StringTokenizer(currToken);
            while (st.hasMoreTokens()) {
                firstToken2 = st.nextToken();
                if (!firstToken2.equals("vn")) continue;
                if (st.countTokens() != 3) {
                    throw new OBJLoaderException("Invalid number of params for vn: " + st.countTokens());
                }
                x = Double.parseDouble(st.nextToken());
                y = Double.parseDouble(st.nextToken());
                z = Double.parseDouble(st.nextToken());
                v = new Vector3f((float)x, (float)y, (float)z);
                v.normalize();
                nlist.add(v);
            }
        }
        for (String currToken : this.fileString) {
            st = new StringTokenizer(currToken);
            while (st.hasMoreTokens()) {
                firstToken2 = st.nextToken();
                if (!firstToken2.equals("vt")) continue;
                x = Double.parseDouble(st.nextToken());
                y = Double.parseDouble(st.nextToken());
                Vector2f v2 = new Vector2f((float)x, (float)y);
                tlist.add(v2);
            }
        }
        HashMap<Point3i, Integer> indexMap = new HashMap<Point3i, Integer>();
        String groupname = "Default";
        String material = "";
        for (String currToken : this.fileString) {
            StringTokenizer st2 = new StringTokenizer(currToken);
            boolean exit = false;
            while (st2.hasMoreTokens()) {
                firstToken = st2.nextToken();
                if (firstToken.equals("o")) {
                    try {
                        groupname = st2.nextToken();
                    }
                    catch (Exception v2) {
                        // empty catch block
                    }
                    exit = true;
                    break;
                }
                if (!firstToken.equals("usemtl") || !material.equals("")) continue;
                try {
                    material = st2.nextToken();
                }
                catch (Exception v2) {
                    // empty catch block
                }
            }
            if (exit) break;
        }
        this.objectName = groupname;
        this.materialName = material;
        GroupData group = new GroupData();
        group.name = groupname;
        group.material = material;
        this.groupList.clear();
        for (String currToken : this.fileString) {
            StringTokenizer st3 = new StringTokenizer(currToken);
            while (st3.hasMoreTokens()) {
                firstToken = st3.nextToken();
                if (firstToken.equals("g")) {
                    try {
                        groupname = st3.nextToken();
                    }
                    catch (Exception e) {
                        groupname = "";
                    }
                    if (this.groupList.size() == 0 && group.indexList.size() == 0) {
                        groupname = this.objectName;
                    } else {
                        this.groupList.add(group);
                    }
                    group = new GroupData();
                    group.name = groupname;
                    group.material = material;
                    continue;
                }
                if (firstToken.equals("usemtl")) {
                    try {
                        material = st3.nextToken();
                    }
                    catch (Exception e) {
                        material = "";
                    }
                    group.material = material;
                    continue;
                }
                if (!firstToken.equals("f")) continue;
                int n = st3.countTokens();
                int[] indices = new int[n];
                int i = 0;
                while (i < n) {
                    int[] is = this.getIndices(st3.nextToken());
                    Point3i key = new Point3i(is[0], is[1], is[2]);
                    if (!indexMap.containsKey(key)) {
                        this.vertexList.add(new Vector3f((Vector3f)vlist.elementAt(is[0] - 1)));
                        if (tlist.size() > 0) {
                            this.texcoordList.add(new Vector2f((Vector2f)tlist.elementAt(is[1] - 1)));
                        }
                        if (nlist.size() > 0) {
                            this.normalList.add(new Vector3f((Vector3f)nlist.elementAt(is[2] - 1)));
                        }
                        int imapIndex = this.vertexList.size() - 1;
                        indexMap.put(key, imapIndex);
                        indices[i] = imapIndex;
                    } else {
                        indices[i] = (Integer)indexMap.get(key);
                    }
                    ++i;
                }
                i = 0;
                while (i < n - 2) {
                    int[] array = new int[]{indices[0], indices[i + 1], indices[i + 2]};
                    this.indexList.add(array);
                    int[] array2 = new int[3];
                    int j = 0;
                    while (j < 3) {
                        array2[j] = array[j];
                        ++j;
                    }
                    group.indexList.add(array2);
                    ++i;
                }
            }
        }
        this.groupList.add(group);
    }

    protected void expandGroups() {
        for (GroupData g : this.groupList) {
            g.vertexList.clear();
            g.normalList.clear();
            g.texcoordList.clear();
            int[] map = new int[this.vertexList.size()];
            int i = 0;
            while (i < this.vertexList.size()) {
                map[i] = -1;
                ++i;
            }
            for (int[] idx : g.indexList) {
                int i2 = 0;
                while (i2 < idx.length) {
                    if (map[idx[i2]] == -1) {
                        g.vertexList.add(new Vector3f(this.vertexList.elementAt(idx[i2])));
                        g.normalList.add(new Vector3f(this.normalList.elementAt(idx[i2])));
                        if (this.texcoordList.size() > 0) {
                            g.texcoordList.add(new Vector2f(this.texcoordList.elementAt(idx[i2])));
                        }
                        map[idx[i2]] = g.vertexList.size() - 1;
                        idx[i2] = map[idx[i2]];
                    } else {
                        idx[i2] = map[idx[i2]];
                    }
                    ++i2;
                }
            }
        }
    }

    protected int[] getIndices(String s) throws OBJLoaderException {
        int[] out = new int[3];
        String[] st = new String[3];
        int i = 0;
        while (i < 3) {
            st[i] = "";
            ++i;
        }
        int currString = 0;
        int i2 = 0;
        while (i2 < s.length()) {
            if ((s.charAt(i2) < '0' || s.charAt(i2) > '9') && s.charAt(i2) != '/') {
                throw new OBJLoaderException("Error: Unknown face index format: " + s);
            }
            if (s.charAt(i2) != '/') {
                int n = currString;
                st[n] = String.valueOf(st[n]) + s.charAt(i2);
            } else if (currString < 2) {
                ++currString;
            } else {
                throw new OBJLoaderException("Error: Unknown face index format: " + s);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 3) {
            if (st[i2].length() == 0) {
                if (i2 == 0) {
                    throw new OBJLoaderException("Error: Unknown face index format: " + s);
                }
                out[i2] = out[0];
            } else {
                out[i2] = Integer.parseInt(st[i2]);
                if (out[i2] == 0) {
                    throw new OBJLoaderException("Error: Unknown face index format: " + s);
                }
            }
            ++i2;
        }
        return out;
    }

    protected void computeNormals() {
        Vector3f[] faceNormal = new Vector3f[this.indexList.size()];
        Vector3f temp1 = new Vector3f();
        Vector3f temp2 = new Vector3f();
        int counter = 0;
        for (int[] idx : this.indexList) {
            faceNormal[counter] = new Vector3f();
            Vector3f v0 = this.vertexList.elementAt(idx[0]);
            Vector3f v1 = this.vertexList.elementAt(idx[1]);
            Vector3f v2 = this.vertexList.elementAt(idx[2]);
            temp1.sub(v1, v0);
            temp2.sub(v2, v0);
            faceNormal[counter].cross(temp1, temp2);
            faceNormal[counter].normalize();
            ++counter;
        }
        int i = 0;
        while (i < this.vertexList.size()) {
            this.normalList.add(new Vector3f());
            ++i;
        }
        counter = 0;
        Iterator<Object> iterator = this.indexList.iterator();
        while (iterator.hasNext()) {
            int[] idx;
            int[] nArray = idx = iterator.next();
            int n = idx.length;
            int n2 = 0;
            while (n2 < n) {
                int element = nArray[n2];
                Vector3f n3 = this.normalList.elementAt(element);
                n3.add(faceNormal[counter]);
                ++n2;
            }
            ++counter;
        }
        for (Vector3f n : this.normalList) {
            n.normalize();
        }
    }

    public void repOK() throws OBJLoaderException {
        if (this.normalList.size() != this.vertexList.size()) {
            throw new OBJLoaderException("Error: Number of Vertices (" + this.vertexList.size() + ") != Number of Normals (" + this.normalList.size() + ").");
        }
        int counter = 0;
        for (int[] array : this.indexList) {
            int max = this.vertexList.size() - 1;
            if (array[0] < 0 || array[1] < 0 || array[2] < 0 || array[0] > max || array[1] > max || array[2] > max) {
                throw new OBJLoaderException("Error: Index out of bounds: Idx: " + counter + " " + array[0] + ", " + array[1] + ", " + array[2] + " Max: " + max);
            }
            if (array[0] == array[1] || array[0] == array[2] || array[1] == array[2]) {
                throw new OBJLoaderException("Error: Degenerate triangles: Idx: " + counter + " " + array[0] + ", " + array[1] + ", " + array[2]);
            }
            ++counter;
        }
    }

    public void normalize() {
        double max = 0.0;
        for (Vector3f v : this.vertexList) {
            if ((double)Math.abs(v.x) > max) {
                max = Math.abs(v.x);
            }
            if ((double)Math.abs(v.y) > max) {
                max = Math.abs(v.y);
            }
            if (!((double)Math.abs(v.z) > max)) continue;
            max = Math.abs(v.z);
        }
        for (Vector3f v : this.vertexList) {
            v.x = (float)((double)v.x / max);
            v.y = (float)((double)v.y / max);
            v.z = (float)((double)v.z / max);
        }
    }

    public Vector<Vector3f> getVertexList() {
        return this.vertexList;
    }

    public Vector<Vector3f> getNormalList() {
        return this.normalList;
    }

    public Vector<Vector2f> getTexcoordList() {
        return this.texcoordList;
    }

    public Vector<int[]> getIndexList() {
        return this.indexList;
    }

    public int getNumberOfVertices() {
        return this.vertexList.size();
    }

    public int getNumberOfIndices() {
        return this.indexList.size();
    }

    public Vector<GroupData> getGroupList() {
        return this.groupList;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getMaterialName() {
        return this.materialName;
    }
}

